/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.office365connector.utils;

import hudson.util.FormValidation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;

public final class FormUtils {
    private FormUtils() {
    }

    public static FormValidation formValidateUrl(String value) {
        if (FormUtils.isUrlValid(value)) {
            return FormValidation.ok();
        }
        return FormValidation.error((String)"Valid URL or variable reference must be provided");
    }

    public static boolean isUrlValid(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        if (value.startsWith("$") && value.length() > 1) {
            return true;
        }
        return UrlValidator.getInstance().isValid(value);
    }
}

