/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.office365connector.model.adaptivecard;

import com.google.gson.annotations.SerializedName;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.model.Result;
import java.util.ArrayList;
import java.util.List;
import jenkins.plugins.office365connector.model.Card;
import jenkins.plugins.office365connector.model.CardAction;
import jenkins.plugins.office365connector.model.Section;
import jenkins.plugins.office365connector.model.adaptivecard.AdaptiveCardElement;
import jenkins.plugins.office365connector.model.adaptivecard.Column;
import jenkins.plugins.office365connector.model.adaptivecard.ColumnSet;
import jenkins.plugins.office365connector.model.adaptivecard.FactSet;
import jenkins.plugins.office365connector.model.adaptivecard.MsTeams;
import jenkins.plugins.office365connector.model.adaptivecard.Payload;
import jenkins.plugins.office365connector.model.adaptivecard.TextBlock;

public class AdaptiveCard
implements Card {
    private String type = "AdaptiveCard";
    @SerializedName(value="$schema")
    @SuppressFBWarnings(value={"SS_SHOULD_BE_STATIC"})
    private final String schema = "http://adaptivecards.io/schemas/adaptive-card.json";
    @SuppressFBWarnings(value={"SS_SHOULD_BE_STATIC"})
    private final String version = "1.4";
    private final MsTeams msTeams = new MsTeams();
    private final List<AdaptiveCardElement> body = new ArrayList<AdaptiveCardElement>();
    private List<CardAction> actions;

    public AdaptiveCard(String summary, Section section, Result result) {
        this.body.add(new TextBlock(summary, "large", "bolder", this.color(result)));
        if (section != null) {
            this.body.add(new ColumnSet(List.of(new Column(List.of(new TextBlock(section.getActivityTitle(), "default", "bolder"), new TextBlock(section.getActivitySubtitle()))))));
            if (!section.getFacts().isEmpty()) {
                this.body.add(new FactSet(section.getFacts()));
            }
        }
    }

    private String color(Result result) {
        if (result.equals(Result.SUCCESS)) {
            return "good";
        }
        if (result.equals(Result.UNSTABLE)) {
            return "warning";
        }
        if (result.equals(Result.FAILURE)) {
            return "attention";
        }
        return "default";
    }

    public String getType() {
        return this.type;
    }

    public String getSchema() {
        return "http://adaptivecards.io/schemas/adaptive-card.json";
    }

    public String getVersion() {
        return "1.4";
    }

    public MsTeams getMsTeams() {
        return this.msTeams;
    }

    public List<AdaptiveCardElement> getBody() {
        return this.body;
    }

    public List<CardAction> getActions() {
        return this.actions;
    }

    @Override
    public Object toPaylod() {
        return new Payload(this);
    }

    @Override
    public void setAction(List<CardAction> actions) {
        this.actions = actions;
    }

    @Override
    public void setThemeColor(String cardThemeColor) {
    }

    @Override
    public String getSummary() {
        return null;
    }

    @Override
    public List<Section> getSections() {
        return List.of();
    }

    @Override
    public String getThemeColor() {
        return null;
    }
}

