/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.office365connector;

import hudson.FilePath;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.File;
import java.io.IOException;
import jenkins.plugins.office365connector.Webhook;
import jenkins.plugins.office365connector.model.Macro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;
import org.jenkinsci.plugins.tokenmacro.TokenMacro;

public class DecisionMaker {
    private final Run run;
    private final TaskListener taskListener;
    private final Result previousResult;

    public DecisionMaker(Run run, TaskListener listener) {
        this.run = run;
        this.taskListener = listener;
        Run previousBuild = run.getPreviousBuild();
        this.previousResult = previousBuild != null ? previousBuild.getResult() : Result.SUCCESS;
    }

    public boolean isAtLeastOneRuleMatched(Webhook webhook) {
        if (webhook.getMacros().isEmpty()) {
            return true;
        }
        for (Macro macro : webhook.getMacros()) {
            String evaluated = this.evaluateMacro(macro.getTemplate());
            if (!evaluated.equals(macro.getValue())) continue;
            this.log("Matched template '%s' for webhook with name '%s'.", macro.getTemplate(), webhook.getName());
            return true;
        }
        return false;
    }

    public boolean isStatusMatched(Webhook webhook) {
        boolean statusMatched;
        Result result = this.run.getResult();
        boolean bl = statusMatched = this.isNotifyAborted(result, webhook) || this.isNotifyFailure(result, webhook) || this.isNotifyRepeatedFailure(result, webhook) || this.isNotifyNotBuilt(result, webhook) || this.isNotifyBackToNormal(result, webhook) || this.isNotifySuccess(result, webhook) || this.isNotifyUnstable(result, webhook);
        if (statusMatched) {
            this.log("Matched status '%s' for webhook with name '%s'.", result, webhook.getName());
        }
        return statusMatched;
    }

    private boolean isNotifyAborted(Result result, Webhook webhook) {
        return webhook.isNotifyAborted() && result == Result.ABORTED;
    }

    private boolean isNotifyFailure(Result result, Webhook webhook) {
        return webhook.isNotifyFailure() && result == Result.FAILURE && this.previousResult != Result.FAILURE;
    }

    private boolean isNotifyRepeatedFailure(Result result, Webhook webhook) {
        return webhook.isNotifyRepeatedFailure() && result == Result.FAILURE && this.previousResult == Result.FAILURE;
    }

    private boolean isNotifyNotBuilt(Result result, Webhook webhook) {
        return webhook.isNotifyNotBuilt() && result == Result.NOT_BUILT;
    }

    private boolean isNotifyBackToNormal(Result result, Webhook webhook) {
        if (!webhook.isNotifyBackToNormal() || result != Result.SUCCESS) {
            return false;
        }
        Run previousBuild = this.findLastCompletedBuild();
        if (previousBuild == null) {
            return false;
        }
        Result previousResult = previousBuild.getResult();
        return previousResult == Result.FAILURE || previousResult == Result.UNSTABLE;
    }

    private Run findLastCompletedBuild() {
        Run previousBuild;
        for (previousBuild = this.run.getPreviousBuild(); previousBuild != null && previousBuild.getResult() == Result.ABORTED; previousBuild = previousBuild.getPreviousCompletedBuild()) {
        }
        return previousBuild;
    }

    private boolean isNotifySuccess(Result result, Webhook webhook) {
        return webhook.isNotifySuccess() && result == Result.SUCCESS;
    }

    private boolean isNotifyUnstable(Result result, Webhook webhook) {
        return webhook.isNotifyUnstable() && result == Result.UNSTABLE;
    }

    private String evaluateMacro(String template) {
        try {
            File workspace = this.run.getRootDir();
            return TokenMacro.expandAll((Run)this.run, (FilePath)new FilePath(workspace), (TaskListener)this.taskListener, (String)template);
        }
        catch (IOException | InterruptedException | MacroEvaluationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void log(String format, Object ... args) {
        this.taskListener.getLogger().println("[Office365connector] " + String.format(format, args));
    }
}

