/*
 * Decompiled with CFR 0.152.
 */
package com.datalex.jdkparameter;

import com.datalex.jdkparameter.JavaParameterValue;
import hudson.Extension;
import hudson.model.JDK;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest2;

public class JavaParameterDefinition
extends ParameterDefinition {
    private static final Logger LOGGER = Logger.getLogger(JavaParameterValue.class.getName());
    public static final String DEFAULT_JDK = "(Default)";
    public static final String ALL_JDK = "(All)";
    public final String defaultJDK;
    public final List<String> allowedJDKs;

    @DataBoundConstructor
    public JavaParameterDefinition(String name, String description, String defaultJDK, List<String> allowedJDKs) {
        super(name, description);
        this.defaultJDK = defaultJDK;
        this.allowedJDKs = allowedJDKs.contains(ALL_JDK) ? Arrays.asList(ALL_JDK) : allowedJDKs;
    }

    public static List<String> getJDKNames() {
        List<String> result = JavaParameterDefinition.getJDKSasStrings();
        Collections.sort(result);
        result.add(0, DEFAULT_JDK);
        result.add(0, ALL_JDK);
        return result;
    }

    public static List<String> getJDKNamesDefault() {
        List<String> result = JavaParameterDefinition.getJDKSasStrings();
        result.add(0, DEFAULT_JDK);
        return result;
    }

    protected static List<String> getJDKSasStrings() {
        List jdkList = Jenkins.getInstance().getJDKs();
        ArrayList<String> result = new ArrayList<String>();
        for (JDK jdk : jdkList) {
            result.add(jdk.getName());
        }
        return result;
    }

    public List<String> getAllowedJDKs() {
        return this.allowedJDKs;
    }

    public List<String> getDisplayableJDKs() {
        boolean shouldAddDefaultJDK;
        if (this.allowedJDKs.contains(ALL_JDK)) {
            ArrayList<String> jdks = new ArrayList<String>();
            jdks.add(DEFAULT_JDK);
            jdks.addAll(JavaParameterDefinition.getJDKSasStrings());
            if (!jdks.contains(this.getDefaultJDK()) && JavaParameterDefinition.getJDKSasStrings().contains(this.getDefaultJDK())) {
                jdks.add(this.getDefaultJDK());
            }
            Collections.sort(jdks);
            for (String jdk : jdks) {
                if (this.getAllowedJDKs().contains(jdk) || jdk.equalsIgnoreCase(DEFAULT_JDK)) continue;
                LOGGER.log(Level.INFO, "[JDK Parameter]: " + jdk + " which was configured has been removed from Jenkins.");
            }
            return jdks;
        }
        ArrayList<String> jdks2 = new ArrayList<String>();
        jdks2.addAll(this.allowedJDKs);
        boolean bl = shouldAddDefaultJDK = !jdks2.contains(this.getDefaultJDK()) && (JavaParameterDefinition.getJDKSasStrings().contains(this.getDefaultJDK()) || this.getDefaultJDK().equals(DEFAULT_JDK));
        if (shouldAddDefaultJDK) {
            jdks2.add(this.getDefaultJDK());
        }
        Collections.sort(jdks2);
        for (String jdk : jdks2) {
            if (this.getAllowedJDKs().contains(jdk) || jdk.equalsIgnoreCase(DEFAULT_JDK)) continue;
            LOGGER.log(Level.INFO, "[JDK Parameter]: " + jdk + " which was configured has been removed from Jenkins.");
        }
        return jdks2;
    }

    public String getDefaultJDK() {
        return this.defaultJDK;
    }

    public List<String> getSelectableJDKNames() {
        List<String> result = JavaParameterDefinition.getJDKSasStrings();
        return result;
    }

    public ParameterValue createValue(StaplerRequest2 req, JSONObject jo) {
        String name = jo.getString("name");
        String selectedJDK = jo.getString("selectedJDK");
        return new JavaParameterValue(name, this.getDescription(), selectedJDK);
    }

    public ParameterValue createValue(StaplerRequest2 req) {
        String name = (String)req.getAttribute("name");
        String selectedJDK = (String)req.getAttribute("selectedJDK");
        return new JavaParameterValue(name, this.getDescription(), selectedJDK);
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "JDK Parameter";
        }
    }
}

