/*
 * Decompiled with CFR 0.152.
 */
package com.datalex.jdkparameter;

import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.JDK;
import hudson.tasks.BuildWrapper;
import java.io.IOException;
import jenkins.model.Jenkins;

public class JavaParameterBuildWrapper
extends BuildWrapper {
    private String originalJDK;
    private boolean jdkIsAvailable;

    public String getOriginalJDK() {
        return this.originalJDK;
    }

    public void setOriginalJDK(String originalJDK) {
        this.originalJDK = originalJDK;
    }

    public boolean isJdkIsAvailable() {
        return this.jdkIsAvailable;
    }

    public void setJdkIsAvailable(boolean jdkIsAvailable) {
        this.jdkIsAvailable = jdkIsAvailable;
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException, InterruptedException, IOException {
        return new BuildWrapper.Environment(){

            public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
                JDK original = null;
                for (JDK jdk : Jenkins.getInstance().getJDKs()) {
                    if (!jdk.getName().equalsIgnoreCase(JavaParameterBuildWrapper.this.getOriginalJDK())) continue;
                    original = jdk;
                    break;
                }
                if (!JavaParameterBuildWrapper.this.jdkIsAvailable) {
                    listener.getLogger().println("[JDK Parameter]: The selected JDK is not available.");
                }
                listener.getLogger().println("[JDK Parameter]: Restored job JDK");
                original = original == null ? new JDK("(Default)", null) : original;
                build.getProject().setJDK(original);
                return true;
            }
        };
    }
}

