/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.credentials;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.time.Duration;
import java.util.function.Supplier;

final class ConjurCustomSuppliers {
    private ConjurCustomSuppliers() {
    }

    public static <T> Supplier<T> memoizeWithExpiration(Supplier<T> base, Duration duration) {
        return new ExpiringMemoizingSupplier<T>(base, duration);
    }

    static class ExpiringMemoizingSupplier<T>
    implements Supplier<T>,
    Serializable {
        private static final long serialVersionUID = 0L;
        final Supplier<T> delegate;
        final Duration duration;
        volatile transient T value;
        volatile transient long expirationNanos;

        ExpiringMemoizingSupplier(Supplier<T> delegate, Duration duration) {
            this.delegate = (Supplier)Preconditions.checkNotNull(delegate);
            this.duration = duration;
        }

        private long getDurationNanos() {
            Duration d = this.duration;
            Preconditions.checkArgument((!d.isNegative() && !d.isZero() ? 1 : 0) != 0);
            return d.toNanos();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            long nanos = this.expirationNanos;
            long now = System.nanoTime();
            if (nanos == 0L || now - nanos >= 0L) {
                ExpiringMemoizingSupplier expiringMemoizingSupplier = this;
                synchronized (expiringMemoizingSupplier) {
                    if (nanos == this.expirationNanos) {
                        T t = this.delegate.get();
                        this.value = t;
                        nanos = now + this.getDurationNanos();
                        this.expirationNanos = nanos == 0L ? 1L : nanos;
                        return t;
                    }
                }
            }
            return this.value;
        }
    }
}

