/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import com.cloudbees.jenkins.plugins.sshcredentials.impl.BaseSSHUser;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.conjur.jenkins.api.ConjurAPIUtils;
import org.conjur.jenkins.conjursecrets.ConjurSecretCredentials;
import org.conjur.jenkins.conjursecrets.ConjurSecretUsernameSSHKeyCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ConjurSecretUsernameSSHKeyCredentialsImpl
extends BaseSSHUser
implements ConjurSecretUsernameSSHKeyCredentials {
    private static final long serialVersionUID = 1L;
    private static final String DISPLAY_NAME = "Conjur Secret Username SSHKey Credential";
    private String credentialID;
    private Secret passphrase;
    transient ModelObject context;
    private transient ModelObject inheritedObjectContext;
    boolean storedInConjurStorage = false;

    @DataBoundConstructor
    public ConjurSecretUsernameSSHKeyCredentialsImpl(CredentialsScope scope, String id, String username, String credentialID, Secret passphrase, String description) {
        super(scope, id, username, description);
        this.credentialID = credentialID;
        this.passphrase = passphrase;
    }

    public String getCredentialID() {
        return this.credentialID;
    }

    @DataBoundSetter
    public void setCredentialID(String credentialID) {
        this.credentialID = credentialID;
    }

    public Secret getPassphrase() {
        return this.passphrase;
    }

    @DataBoundSetter
    public void setPassphrase(Secret passphrase) {
        this.passphrase = passphrase;
    }

    public static String getDescriptorDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public String getDisplayName() {
        return "ConjurSecretUsernameSSHKey:" + this.username;
    }

    @Override
    public String getNameTag() {
        return "";
    }

    @Override
    public Secret getSecret() {
        return null;
    }

    @Override
    public void setContext(ModelObject context) {
        this.context = context;
    }

    @Override
    public ModelObject getContext() {
        return this.context;
    }

    @Override
    public void setInheritedContext(ModelObject context) {
        this.inheritedObjectContext = context;
    }

    @Override
    public ModelObject getInheritedContext() {
        return this.inheritedObjectContext;
    }

    @Override
    public void setStoredInConjurStorage(boolean storedInConjurStorage) {
        this.storedInConjurStorage = storedInConjurStorage;
    }

    @Override
    public boolean storedInConjurStorage() {
        return this.storedInConjurStorage;
    }

    @Override
    public String getPrivateKey() {
        Object searchContext = this.context != null ? this.context : Jenkins.get();
        ConjurSecretCredentials credential = (ConjurSecretCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(ConjurSecretCredentials.class, (ItemGroup)((ItemGroup)searchContext), (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)this.credentialID));
        if (credential != null) {
            return credential.getSecret().getPlainText();
        }
        return "";
    }

    public List<String> getPrivateKeys() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(this.getPrivateKey());
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return ConjurSecretUsernameSSHKeyCredentialsImpl.getDescriptorDisplayName();
        }

        public ListBoxModel doFillCredentialIDItems(@AncestorInPath Item item, @QueryParameter String uri) {
            Jenkins.get().checkPermission(Jenkins.ADMINISTER);
            return new StandardListBoxModel().includeAs(ACL.SYSTEM, item, ConjurSecretCredentials.class, URIRequirementBuilder.fromUri((String)uri).build());
        }

        public FormValidation doTestConnection(@AncestorInPath ItemGroup<Item> context, @QueryParameter(value="credentialID") String credentialID, @QueryParameter(value="passphrase") Secret passphrase, @QueryParameter(value="username") String username) {
            if (username == null || credentialID == null || passphrase == null) {
                return FormValidation.error((String)"FAILED username,passphrase,credentialID fields is required");
            }
            ConjurSecretUsernameSSHKeyCredentialsImpl credential = new ConjurSecretUsernameSSHKeyCredentialsImpl(CredentialsScope.GLOBAL, "test", username, credentialID, passphrase, "desc");
            return ConjurAPIUtils.validateCredential(context, credential);
        }
    }
}

