/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.NameWith;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.logging.Level;
import org.conjur.jenkins.api.ConjurAPI;
import org.conjur.jenkins.api.ConjurAPIUtils;
import org.conjur.jenkins.conjursecrets.ConjurSecretCredentials;
import org.conjur.jenkins.conjursecrets.ConjurSecretUsernameCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

@NameWith(value=ConjurSecretCredentials.NameProvider.class, priority=1)
public class ConjurSecretUsernameCredentialsImpl
extends BaseStandardCredentials
implements ConjurSecretUsernameCredentials {
    private static final long serialVersionUID = 1L;
    private static final String name = "Conjur Secret Username Credential";
    private String username;
    private String variableId;
    private transient ModelObject context;
    private transient ModelObject inheritedObjectContext;
    boolean storedInConjurStorage = false;

    @DataBoundConstructor
    public ConjurSecretUsernameCredentialsImpl(CredentialsScope scope, String id, String username, String variableId, String description) {
        super(scope, id, description);
        LOGGER.log(Level.FINEST, String.format("ConjurSecretUsernameCredentialsImpl, id %s", id));
        this.username = username;
        this.variableId = variableId;
    }

    public String getUsername() {
        return this.username;
    }

    @DataBoundSetter
    public void setUserName(String username) {
        this.username = username;
    }

    public String getVariableId() {
        return this.variableId;
    }

    @DataBoundSetter
    public void setVariableId(String variableId) {
        this.variableId = variableId;
    }

    public static String getDescriptorDisplayName() {
        return name;
    }

    @Override
    public String getDisplayName() {
        return "ConjurSecretUsername:" + this.getVariableId();
    }

    @Override
    public void setContext(ModelObject context) {
        this.context = context;
    }

    @Override
    public ModelObject getContext() {
        return this.context;
    }

    @Override
    public void setInheritedContext(ModelObject context) {
        this.inheritedObjectContext = context;
    }

    @Override
    public ModelObject getInheritedContext() {
        return this.inheritedObjectContext;
    }

    @Override
    public void setStoredInConjurStorage(boolean storedInConjurStorage) {
        this.storedInConjurStorage = storedInConjurStorage;
    }

    @Override
    public boolean storedInConjurStorage() {
        return this.storedInConjurStorage;
    }

    @Override
    public Secret getSecret() {
        return this.getPassword();
    }

    public Secret getPassword() {
        LOGGER.log(Level.FINEST, String.format("getPassword, stored %b context %s", this.storedInConjurStorage, this.context));
        Secret retSecret = null;
        retSecret = this.storedInConjurStorage ? ConjurAPI.getSecretFromConjur(this.context, this.inheritedObjectContext, this.variableId) : ConjurAPI.getSecretFromConjurWithInheritance(this.context, this, this.variableId);
        return retSecret;
    }

    @Override
    public String getNameTag() {
        return "";
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return ConjurSecretUsernameCredentialsImpl.getDescriptorDisplayName();
        }

        public FormValidation doTestConnection(@AncestorInPath ItemGroup<Item> context, @QueryParameter(value="variableId") String variableId, @QueryParameter(value="username") String username) {
            if (username == null || variableId == null) {
                return FormValidation.error((String)"FAILED username,credentialID fields is required");
            }
            ConjurSecretUsernameCredentialsImpl credential = new ConjurSecretUsernameCredentialsImpl(CredentialsScope.GLOBAL, "test", username, variableId, "desc");
            return ConjurAPIUtils.validateCredential(context, credential);
        }
    }
}

