/*
 * Decompiled with CFR 0.152.
 */
package org.conjur.jenkins.conjursecrets;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.util.FormValidation;
import hudson.util.Secret;
import org.conjur.jenkins.api.ConjurAPIUtils;
import org.conjur.jenkins.conjursecrets.ConjurSecretDockerCertCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ConjurSecretDockerCertCredentialsImpl
extends ConjurSecretDockerCertCredentials {
    private static final long serialVersionUID = 1L;
    private final String clientKeyId;
    private final String clientCertificateId;
    private final String caCertificateId;
    private transient ModelObject context;
    private transient ModelObject inheritedObjectContext;
    private boolean storedInConjurStorage = false;

    @DataBoundConstructor
    public ConjurSecretDockerCertCredentialsImpl(CredentialsScope scope, String id, String description, String clientKeyId, String clientCertificateId, String caCertificateId) {
        super(scope, id, description);
        this.clientKeyId = clientKeyId;
        this.clientCertificateId = clientCertificateId;
        this.caCertificateId = caCertificateId;
    }

    @Override
    public Secret getSecret() {
        return this.getClientKeySecret();
    }

    @Override
    public String getClientKeyId() {
        return this.clientKeyId;
    }

    @Override
    public String getClientCertificateId() {
        return this.clientCertificateId;
    }

    @Override
    public String getCaCertificateId() {
        return this.caCertificateId;
    }

    @Override
    public String getDisplayName() {
        return "ConjurSecretDockerCert:" + this.getId();
    }

    @Override
    public String getNameTag() {
        return "";
    }

    @Override
    public void setContext(ModelObject context) {
        this.context = context;
    }

    @Override
    public ModelObject getContext() {
        return this.context;
    }

    @Override
    public void setInheritedContext(ModelObject context) {
        this.inheritedObjectContext = context;
    }

    @Override
    public ModelObject getInheritedContext() {
        return this.inheritedObjectContext;
    }

    @Override
    public void setStoredInConjurStorage(boolean stored) {
        this.storedInConjurStorage = stored;
    }

    @Override
    public boolean storedInConjurStorage() {
        return this.storedInConjurStorage;
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "Conjur Secret Docker Client Certificate";
        }

        public FormValidation doTestConnection(@AncestorInPath ItemGroup<Item> context, @QueryParameter(value="clientKeyId") String clientKeyId, @QueryParameter(value="clientCertificateId") String clientCertificateId, @QueryParameter(value="caCertificateId") String caCertificateId) {
            if (clientKeyId == null || clientCertificateId == null || caCertificateId == null) {
                return FormValidation.error((String)"All certificate fields are required");
            }
            ConjurSecretDockerCertCredentialsImpl credential = new ConjurSecretDockerCertCredentialsImpl(CredentialsScope.GLOBAL, "test", "desc", clientKeyId, clientCertificateId, caCertificateId);
            return ConjurAPIUtils.validateCredential(context, credential);
        }
    }
}

