/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.net;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonNegative;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import net.shibboleth.shared.primitive.StringSupport;
import org.slf4j.Logger;

public class CookieManager
extends AbstractInitializableComponent {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(CookieManager.class);
    @Nullable
    private String cookiePath;
    @Nullable
    private String cookieDomain;
    @NonnullAfterInit
    private NonnullSupplier<HttpServletRequest> httpRequestSupplier;
    @NonnullAfterInit
    private NonnullSupplier<HttpServletResponse> httpResponseSupplier;
    private boolean secure = true;
    private boolean httpOnly = true;
    private int maxAge = -1;
    private boolean guardSetAttribute = true;
    @Nonnull
    private SameSiteValue defaultSameSite = SameSiteValue.Null;
    @Nonnull
    private Map<String, SameSiteValue> sameSiteCookies = CollectionSupport.emptyMap();
    @Nonnull
    private Predicate<HttpServletRequest> sameSiteCondition = PredicateSupport.alwaysTrue();
    @Nonnull
    private Map<String, String> cookieAttributes = CollectionSupport.emptyMap();
    @NonNegative
    private int cookieLimit = 0;

    @Nullable
    public String getCookiePath() {
        return this.cookiePath;
    }

    public void setCookiePath(@Nullable String path) {
        this.checkSetterPreconditions();
        this.cookiePath = StringSupport.trimOrNull((String)path);
    }

    @Nullable
    public String getCookieDomain() {
        return this.cookieDomain;
    }

    public void setCookieDomain(@Nullable String domain) {
        this.checkSetterPreconditions();
        this.cookieDomain = StringSupport.trimOrNull((String)domain);
    }

    public void setHttpServletRequestSupplier(@Nonnull NonnullSupplier<HttpServletRequest> requestSupplier) {
        this.checkSetterPreconditions();
        this.httpRequestSupplier = (NonnullSupplier)Constraint.isNotNull(requestSupplier, (String)"HttpServletRequest cannot be null");
    }

    @NonnullAfterInit
    protected HttpServletRequest getHttpServletRequest() {
        if (this.httpRequestSupplier == null) {
            return null;
        }
        return (HttpServletRequest)this.httpRequestSupplier.get();
    }

    public void setHttpServletResponseSupplier(@Nonnull NonnullSupplier<HttpServletResponse> responseSupplier) {
        this.checkSetterPreconditions();
        this.httpResponseSupplier = (NonnullSupplier)Constraint.isNotNull(responseSupplier, (String)"HttpServletResponse cannot be null");
    }

    @NonnullAfterInit
    protected HttpServletResponse getHttpServletResponse() {
        if (this.httpResponseSupplier == null) {
            return null;
        }
        return (HttpServletResponse)this.httpResponseSupplier.get();
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean flag) {
        this.checkSetterPreconditions();
        this.secure = flag;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean flag) {
        this.checkSetterPreconditions();
        this.httpOnly = flag;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(int age) {
        this.checkSetterPreconditions();
        this.maxAge = age;
    }

    public void setMaxAgeDuration(@Nonnull Duration age) {
        this.checkSetterPreconditions();
        this.maxAge = (int)((Duration)Constraint.isNotNull((Object)age, (String)"Age cannot be null")).getSeconds();
        if (this.maxAge < 0) {
            this.maxAge = -1;
        }
    }

    public void setGuardSetAttribute(boolean flag) {
        this.checkSetterPreconditions();
        this.guardSetAttribute = flag;
    }

    @Nonnull
    public SameSiteValue getSameSite() {
        return this.defaultSameSite;
    }

    public void setSameSite(@Nonnull SameSiteValue value) {
        this.checkSetterPreconditions();
        this.defaultSameSite = (SameSiteValue)((Object)Constraint.isNotNull((Object)((Object)value), (String)"SameSite Value cannot be null"));
    }

    public void setSameSiteCookies(@Nullable Map<SameSiteValue, List<String>> map) {
        if (map != null) {
            this.sameSiteCookies = new HashMap<String, SameSiteValue>(4);
            for (Map.Entry<SameSiteValue, List<String>> entry : map.entrySet()) {
                for (String cookieName : entry.getValue()) {
                    if (this.sameSiteCookies.get(cookieName) != null) {
                        this.log.error("Duplicate cookie name '{}' found in SameSite cookie map, please check configuration.", (Object)cookieName);
                        throw new IllegalArgumentException("Duplicate cookie name found in SameSite cookie map");
                    }
                    String trimmedName = StringSupport.trimOrNull((String)cookieName);
                    if (trimmedName == null) continue;
                    this.sameSiteCookies.put(cookieName, entry.getKey());
                }
            }
        } else {
            this.sameSiteCookies = CollectionSupport.emptyMap();
        }
    }

    @Nonnull
    public Predicate<HttpServletRequest> getSameSiteCondition() {
        return this.sameSiteCondition;
    }

    public void setSameSiteCondition(@Nonnull Predicate<HttpServletRequest> condition) {
        this.checkSetterPreconditions();
        this.sameSiteCondition = (Predicate)Constraint.isNotNull(condition, (String)"SameSite condition cannot be null");
    }

    @Nonnull
    @NotLive
    @Unmodifiable
    public Map<String, String> getCookieAttributes() {
        return this.cookieAttributes;
    }

    public void setCookieAttributes(@Nullable Map<String, String> attributes) {
        this.checkSetterPreconditions();
        this.cookieAttributes = attributes != null ? CollectionSupport.copyToMap(attributes) : CollectionSupport.emptyMap();
    }

    @NonNegative
    public int getCookieLimit() {
        return this.cookieLimit;
    }

    public void setCookieLimit(@NonNegative int limit) {
        this.checkSetterPreconditions();
        this.cookieLimit = Constraint.isGreaterThanOrEqual((int)0, (int)limit, (String)"");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpRequestSupplier == null || this.httpResponseSupplier == null) {
            throw new ComponentInitializationException("Servlet request and response suppliers must be set");
        }
    }

    public void addCookie(@Nonnull @NotEmpty String name, @Nonnull @NotEmpty String value) {
        this.addCookie(name, value, this.getCookiePath(), this.getMaxAge());
    }

    public void addCookie(@Nonnull @NotEmpty String name, @Nonnull @NotEmpty String value, int overrideMaxAge) {
        this.addCookie(name, value, this.getCookiePath(), overrideMaxAge);
    }

    public void addCookie(@Nonnull @NotEmpty String name, @Nonnull @NotEmpty String value, @Nullable @NotEmpty String overridePath, int overrideMaxAge) {
        this.checkComponentActive();
        Cookie cookie = new Cookie(name, value);
        cookie.setPath(overridePath != null ? overridePath : this.contextPathToCookiePath());
        if (this.getCookieDomain() != null) {
            cookie.setDomain(this.getCookieDomain());
        }
        cookie.setSecure(this.isSecure());
        cookie.setHttpOnly(this.isHttpOnly());
        cookie.setMaxAge(overrideMaxAge);
        if (!this.guardSetAttribute || this.getHttpServletRequest().getServletContext().getMajorVersion() >= 6) {
            this.attachSameSite(cookie);
            this.cookieAttributes.forEach((n, v) -> cookie.setAttribute(n, v));
        }
        this.getHttpServletResponse().addCookie(cookie);
    }

    public void unsetCookie(@Nonnull @NotEmpty String name) {
        this.unsetCookie(name, this.getCookiePath());
    }

    public void unsetCookie(@Nonnull @NotEmpty String name, @Nullable @NotEmpty String overridePath) {
        this.checkComponentActive();
        Cookie cookie = new Cookie(name, null);
        cookie.setPath(overridePath != null ? overridePath : this.contextPathToCookiePath());
        if (this.cookieDomain != null) {
            cookie.setDomain(this.getCookieDomain());
        }
        cookie.setSecure(this.isSecure());
        cookie.setHttpOnly(this.isHttpOnly());
        cookie.setMaxAge(0);
        if (!this.guardSetAttribute || this.getHttpServletRequest().getServletContext().getMajorVersion() >= 6) {
            this.attachSameSite(cookie);
            this.cookieAttributes.forEach((n, v) -> cookie.setAttribute(n, v));
        }
        this.getHttpServletResponse().addCookie(cookie);
    }

    public boolean cookieHasValue(@Nonnull @NotEmpty String name, @Nonnull @NotEmpty String expectedValue) {
        String realValue = this.getCookieValue(name, null);
        if (realValue == null) {
            return false;
        }
        return realValue.equals(expectedValue);
    }

    @Nullable
    public String getCookieValue(@Nonnull @NotEmpty String name, @Nullable String defValue) {
        this.checkComponentActive();
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return defValue;
    }

    public void purgeStaleCookies(@Nonnull @NotEmpty String prefix) {
        this.purgeStaleCookies(prefix, this.getCookiePath());
    }

    public void purgeStaleCookies(@Nonnull @NotEmpty String prefix, @Nullable @NotEmpty String overridePath) {
        if (this.getCookieLimit() == 0) {
            return;
        }
        Cookie[] cookies = this.getHttpServletRequest().getCookies();
        if (cookies == null || cookies.length == 0 || cookies.length <= this.getCookieLimit()) {
            return;
        }
        TreeSet<String> sortedNames = new TreeSet<String>();
        for (Cookie c : cookies) {
            if (!c.getName().startsWith(prefix)) continue;
            sortedNames.add(c.getName());
        }
        int maxCookies = this.getCookieLimit();
        int purgedCookies = 0;
        for (String nameToPurge : sortedNames.descendingSet()) {
            if (maxCookies > 0) {
                --maxCookies;
                continue;
            }
            this.unsetCookie(nameToPurge, overridePath);
            ++purgedCookies;
        }
        if (purgedCookies > 0) {
            this.log.debug("Purged {} stale cookie(s) with prefix '{}'", (Object)purgedCookies, (Object)prefix);
        }
    }

    private void attachSameSite(@Nonnull Cookie cookie) {
        if (!this.sameSiteCondition.test(this.getHttpServletRequest())) {
            return;
        }
        SameSiteValue sameSiteValue = this.sameSiteCookies.get(cookie.getName());
        if (sameSiteValue != null) {
            if (sameSiteValue != SameSiteValue.Null) {
                cookie.setAttribute("SameSite", sameSiteValue.getValue());
            }
        } else if (this.defaultSameSite != SameSiteValue.Null) {
            cookie.setAttribute("SameSite", this.defaultSameSite.getValue());
        }
    }

    @Nonnull
    @NotEmpty
    private String contextPathToCookiePath() {
        HttpServletRequest httpRequest = this.getHttpServletRequest();
        return "".equals(httpRequest.getContextPath()) ? "/" : httpRequest.getContextPath();
    }

    public static enum SameSiteValue {
        Strict("Strict"),
        Lax("Lax"),
        None("None"),
        Null("Null");

        @Nonnull
        @NotEmpty
        private String value;

        private SameSiteValue(String attrValue) {
            this.value = Constraint.isNotEmpty((String)attrValue, (String)"the same-site attribute value can not be empty");
        }

        @Nonnull
        public String getValue() {
            return this.value;
        }
    }
}

