/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.httpclient;

import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.httpclient.AbstractHttpClient;
import net.shibboleth.shared.httpclient.RequestTimeoutExceededException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.classic.RequestFailedException;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.concurrent.Cancellable;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.slf4j.Logger;

public class RequestTimeLimitingHttpClient
extends AbstractHttpClient {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(RequestTimeLimitingHttpClient.class);
    @Nonnull
    private HttpClient httpClient;
    @Nonnull
    private ScheduledExecutorService executorService;
    @Nullable
    private Duration timeout;

    public RequestTimeLimitingHttpClient(@Nonnull HttpClient client, @Nonnull ScheduledExecutorService executor, @Nullable Duration requestTimeout) {
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient was null");
        this.executorService = (ScheduledExecutorService)Constraint.isNotNull((Object)executor, (String)"ScheduledExecutorService was null");
        this.timeout = requestTimeout;
    }

    @Override
    protected ClassicHttpResponse doExecute(@Nullable HttpHost target, @Nonnull ClassicHttpRequest request, @Nullable HttpContext context) throws IOException {
        ScheduledFuture<Boolean> future = null;
        Duration effectiveTimeout = null;
        try {
            Cancellable cancellableRequest;
            if (request instanceof Cancellable) {
                cancellableRequest = (Cancellable)request;
                effectiveTimeout = this.resolveEffectiveTimeout(context);
                if (effectiveTimeout != null) {
                    this.log.debug("Scheduling request timeout of duration: {}", (Object)effectiveTimeout);
                    future = this.executorService.schedule(() -> ((Cancellable)cancellableRequest).cancel(), effectiveTimeout.toMillis(), TimeUnit.MILLISECONDS);
                }
            }
            cancellableRequest = this.httpClient.executeOpen(target, request, context);
            return cancellableRequest;
        }
        catch (RequestFailedException e) {
            String message = e.getMessage();
            if (message.contains("aborted") || message.contains("cancelled")) {
                throw new RequestTimeoutExceededException(String.format("Request to '%s'exceeded timeout '%s'", request.getRequestUri(), effectiveTimeout), e);
            }
            throw e;
        }
        finally {
            if (future != null) {
                future.cancel(true);
            }
        }
    }

    @Nullable
    protected Duration resolveEffectiveTimeout(@Nullable HttpContext context) {
        HttpClientContext clientContext;
        Duration contextTimeout;
        if (context != null && (contextTimeout = (Duration)(clientContext = HttpClientContext.adapt((HttpContext)context)).getAttribute("java-support.RequestTimeout", Duration.class)) != null) {
            this.log.debug("Resolved effective request timeout from client context: {}", (Object)contextTimeout);
            return contextTimeout;
        }
        if (this.timeout != null) {
            this.log.debug("Resolved effective request timeout from statically-configured client value: {}", (Object)this.timeout);
        } else {
            this.log.debug("No effective request timeout was resolved");
        }
        return this.timeout;
    }

    public void close() throws IOException {
        try {
            if (Closeable.class.isInstance(this.httpClient)) {
                ((Closeable)Closeable.class.cast(this.httpClient)).close();
            }
        }
        finally {
            this.executorService.shutdownNow();
        }
    }

    public void close(CloseMode closeMode) {
        try {
            if (ModalCloseable.class.isInstance(this.httpClient)) {
                ((ModalCloseable)ModalCloseable.class.cast(this.httpClient)).close(closeMode);
            }
        }
        finally {
            this.executorService.shutdownNow();
        }
    }
}

