/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.stapler;

import com.sun.xml.txw2.TXW;
import com.sun.xml.txw2.output.StreamSerializer;
import com.sun.xml.txw2.output.XmlSerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkFactory;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.reporting.MavenMultiPageReport;
import org.apache.maven.reporting.MavenReportException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.eclipse.aether.RepositorySystem;
import org.jvnet.maven.jellydoc.Attribute;
import org.jvnet.maven.jellydoc.JellydocMojo;
import org.jvnet.maven.jellydoc.Library;
import org.jvnet.maven.jellydoc.Tag;
import org.jvnet.maven.jellydoc.Tags;

@Mojo(name="jelly-taglibdoc", requiresDependencyResolution=ResolutionScope.COMPILE)
@Execute(phase=LifecyclePhase.GENERATE_SOURCES)
public class TaglibDocMojo
extends AbstractMojo
implements MavenMultiPageReport {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    protected MavenSession session;
    @Parameter(defaultValue="${plugin.artifacts}", required=true, readonly=true)
    private List<Artifact> pluginArtifacts;
    @Parameter(defaultValue="${plugin.version}", required=true, readonly=true)
    private String pluginVersion;
    @Parameter(defaultValue="${patterns}")
    private String[] patterns = new String[]{".*"};
    @Component
    private ArtifactFactory factory;
    @Component
    private RepositorySystem repositorySystem;
    @Component
    private MavenProjectHelper helper;
    private JellydocMojo jellydoc;
    private static final Map<String, String> NAMESPACE_MAP = new HashMap<String, String>();

    public void execute() throws MojoExecutionException {
        this.writeTaglibXml();
        this.getJellydocMojo().generateSchema();
    }

    private JellydocMojo getJellydocMojo() {
        if (this.jellydoc == null) {
            this.jellydoc = new JellydocMojo(){

                public void execute() throws MojoExecutionException {
                    TaglibDocMojo.this.execute();
                }
            };
            this.jellydoc.factory = this.factory;
            this.jellydoc.helper = this.helper;
            this.jellydoc.session = this.session;
            this.jellydoc.project = this.project;
            this.jellydoc.repositorySystem = this.repositorySystem;
        }
        return this.jellydoc;
    }

    private void writeTaglibXml() throws MojoExecutionException {
        try {
            File taglibsXml = new File(this.project.getBasedir(), "target/taglib.xml");
            taglibsXml.getParentFile().mkdirs();
            Tags tags = (Tags)TXW.create(Tags.class, (XmlSerializer)new StreamSerializer((OutputStream)new FileOutputStream(taglibsXml)));
            for (Resource res : this.project.getResources()) {
                this.scanTagLibs(new File(res.getDirectory()), "", tags);
            }
            tags.commit();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to generate taglibs.xml", (Exception)e);
        }
    }

    private void scanTagLibs(File dir, String uri, Tags tags) throws IOException {
        File[] subdirs;
        if (new File(dir, "taglib").exists()) {
            boolean match = this.patterns.length == 0;
            for (String p : this.patterns) {
                if (!Pattern.matches(p, uri)) continue;
                match = true;
                break;
            }
            if (match) {
                this.parseTagLib(dir, uri, tags.library());
            }
        }
        if ((subdirs = dir.listFiles(File::isDirectory)) == null) {
            return;
        }
        for (File subdir : subdirs) {
            this.scanTagLibs(subdir, uri + "/" + subdir.getName(), tags);
        }
    }

    private void parseTagLib(File dir, String uri, Library lib) throws IOException {
        this.getLog().info((CharSequence)("Processing " + String.valueOf(dir)));
        ArrayList<String> markerFile = new ArrayList<String>(Files.readAllLines(dir.toPath().resolve("taglib"), StandardCharsets.UTF_8));
        if (markerFile.size() == 0) {
            markerFile.add(uri);
        }
        lib.name((String)markerFile.get(0));
        lib.prefix(uri.substring(uri.lastIndexOf(47) + 1)).uri(uri);
        lib.doc()._pcdata((Object)String.join((CharSequence)"\n", markerFile));
        File[] tagFiles = dir.listFiles(f -> f.getName().endsWith(".jelly"));
        if (tagFiles == null) {
            return;
        }
        for (File tagFile : tagFiles) {
            this.parseTagFile(tagFile, lib.tag());
        }
    }

    private void parseTagFile(File tagFile, Tag tag) throws IOException {
        try {
            String name = tagFile.getName();
            name = name.substring(0, name.length() - 6);
            tag.name(name);
            DocumentFactory f = new DocumentFactory();
            f.setXPathNamespaceURIs(NAMESPACE_MAP);
            Document jelly = new SAXReader(f).read(tagFile);
            Element doc = (Element)jelly.selectSingleNode(".//s:documentation");
            if (jelly.selectSingleNode("//d:invokeBody") == null) {
                tag.noContent(true);
            }
            if (doc == null) {
                tag.doc("");
            } else {
                tag.doc(doc.getText());
                for (Node node : doc.selectNodes("s:attribute")) {
                    Element attr = (Element)node;
                    Attribute aw = tag.attribute();
                    for (org.dom4j.Attribute a : attr.attributes()) {
                        aw._attribute(a.getName(), (Object)a.getValue());
                    }
                    aw.doc(attr.getText());
                }
            }
        }
        catch (DocumentException e) {
            throw new IOException("Failed to parse " + String.valueOf(tagFile), e);
        }
    }

    @Deprecated
    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.getJellydocMojo().generate(sink, locale);
    }

    public void generate(Sink sink, SinkFactory sinkFactory, Locale locale) throws MavenReportException {
        this.getJellydocMojo().generate(sink, sinkFactory, locale);
    }

    public String getOutputName() {
        return this.getJellydocMojo().getOutputName();
    }

    public String getName(Locale locale) {
        return this.getJellydocMojo().getName(locale);
    }

    public String getCategoryName() {
        return this.getJellydocMojo().getCategoryName();
    }

    public String getDescription(Locale locale) {
        return this.getJellydocMojo().getDescription(locale);
    }

    public void setReportOutputDirectory(File outputDirectory) {
        this.getJellydocMojo().setReportOutputDirectory(outputDirectory);
    }

    public File getReportOutputDirectory() {
        return this.getJellydocMojo().getReportOutputDirectory();
    }

    public boolean isExternalReport() {
        return this.getJellydocMojo().isExternalReport();
    }

    public boolean canGenerateReport() {
        return this.getJellydocMojo().canGenerateReport();
    }

    static {
        NAMESPACE_MAP.put("s", "jelly:stapler");
        NAMESPACE_MAP.put("d", "jelly:define");
    }
}

