/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.webhookexternalstore;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import hudson.Extension;
import hudson.model.ItemGroup;
import hudson.model.ModelObject;
import hudson.security.ACL;
import io.jenkins.plugins.webhookexternalstore.WebhookCredentialsStore;
import io.jenkins.plugins.webhookexternalstore.WebhookPayload;
import io.jenkins.plugins.webhookexternalstore.converters.WebhookToCredentialConverter;
import io.jenkins.plugins.webhookexternalstore.exceptions.CredentialsConvertionException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jenkins.model.Jenkins;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;

@Extension
public class WebhookCredentialsProvider
extends CredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger((String)WebhookCredentialsProvider.class.getName());
    private final ConcurrentHashMap<String, IdCredentials> credentials = new ConcurrentHashMap();
    private final Map<ModelObject, WebhookCredentialsStore> lazyStoreCache = new HashMap<ModelObject, WebhookCredentialsStore>();

    public CredentialsStore getStore(ModelObject object) {
        if (object == null) {
            object = Jenkins.get();
        }
        return this.lazyStoreCache.computeIfAbsent(object, this::createStore);
    }

    public <C extends Credentials> @NonNull List<C> getCredentialsInItemGroup(@NonNull Class<C> type, @Nullable ItemGroup itemGroup, @Nullable Authentication authentication, @NonNull List<DomainRequirement> domainRequirements) {
        ArrayList<Credentials> list = new ArrayList<Credentials>();
        if (ACL.SYSTEM2.equals((Object)authentication)) {
            for (IdCredentials cred : this.credentials.values()) {
                if (!type.isInstance(cred)) continue;
                list.add((Credentials)type.cast(cred));
            }
        }
        return list;
    }

    private WebhookCredentialsStore createStore(ModelObject object) {
        return new WebhookCredentialsStore(this, object);
    }

    public void addOrUpdateCredential(WebhookPayload payload) throws CredentialsConvertionException {
        LOG.debug("Processing webhook payload for credential ID: {}", (Object)payload.getId());
        IdCredentials credential = WebhookToCredentialConverter.convertFromPayload(payload);
        String credentialId = payload.getId();
        this.credentials.put(credentialId, credential);
    }

    public List<IdCredentials> getAllWebhookCredentials() {
        return new ArrayList<IdCredentials>(this.credentials.values());
    }

    public static WebhookCredentialsProvider getInstance() {
        return Jenkins.get().getExtensionList(CredentialsProvider.class).stream().filter(WebhookCredentialsProvider.class::isInstance).map(WebhookCredentialsProvider.class::cast).findFirst().orElseThrow();
    }

    public String getIconClassName() {
        return "symbol-webhook plugin-webhook-secret-credentials-provider";
    }
}

