/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.webhookexternalstore;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.util.Secret;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@Symbol(value={"webhookSecretStore"})
public class WebhookConfiguration
extends GlobalConfiguration {
    private Secret token;

    public WebhookConfiguration() {
        this.load();
    }

    public static WebhookConfiguration getInstance() {
        return (WebhookConfiguration)((Object)GlobalConfiguration.all().get(WebhookConfiguration.class));
    }

    public Secret getToken() {
        return this.token;
    }

    @DataBoundSetter
    public void setToken(Secret token) {
        this.token = token;
        this.save();
    }

    public boolean isTokenConfigured() {
        return this.token != null && !Secret.toString((Secret)this.token).isBlank();
    }

    public boolean isValidBearerToken(String providedToken) {
        if (!this.isTokenConfigured() || providedToken == null || providedToken.isBlank()) {
            return false;
        }
        String configuredToken = Secret.toString((Secret)this.token);
        return configuredToken.equals(providedToken);
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public boolean configure(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
        req.bindJSON((Object)this, formData);
        return super.configure(req, formData);
    }

    @NonNull
    public String getDisplayName() {
        return "Webhook External Secret Credentials Provider";
    }
}

