/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.venaficodesigning;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import io.jenkins.plugins.venaficodesigning.Messages;
import java.net.MalformedURLException;
import java.net.URL;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

@XStreamAlias(value="tpp-config")
public class TppConfig
extends AbstractDescribableImpl<TppConfig> {
    private final String name;
    private final String authUrl;
    private final String hsmUrl;

    @DataBoundConstructor
    public TppConfig(String name, String authUrl, String hsmUrl) {
        this.name = name;
        this.authUrl = authUrl;
        this.hsmUrl = hsmUrl;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthUrl() {
        return this.authUrl;
    }

    public String getHsmUrl() {
        return this.hsmUrl;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<TppConfig> {
        public String getDisplayName() {
            return Messages.TppConfig_displayName();
        }

        public FormValidation doCheckName(@QueryParameter String value, @QueryParameter String id) {
            return FormValidation.validateRequired((String)value);
        }

        public FormValidation doCheckAuthUrl(@QueryParameter String value) {
            FormValidation result = FormValidation.validateRequired((String)value);
            if (result.kind != FormValidation.Kind.OK) {
                return result;
            }
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)Messages.TppConfig_authUrlMalformed(), (Object[])new Object[]{e.getMessage()});
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckHsmUrl(@QueryParameter String value) {
            FormValidation result = FormValidation.validateRequired((String)value);
            if (result.kind != FormValidation.Kind.OK) {
                return result;
            }
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                return FormValidation.error((String)Messages.TppConfig_hsmUrlMalformed(), (Object[])new Object[]{e.getMessage()});
            }
            return FormValidation.ok();
        }
    }
}

