/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.venaficodesigning;

import com.cloudbees.plugins.credentials.domains.SchemeRequirement;
import com.thoughtworks.xstream.XStream;
import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Descriptor;
import io.jenkins.plugins.venaficodesigning.Messages;
import io.jenkins.plugins.venaficodesigning.TppConfig;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class PluginConfig
extends GlobalConfiguration {
    public static final SchemeRequirement HTTP_SCHEME = new SchemeRequirement("http");
    public static final SchemeRequirement HTTPS_SCHEME = new SchemeRequirement("https");
    public static final String CONFIGURATION_ID = "venafi-code-signing-plugin-configuration";
    public static final PluginConfig EMPTY_CONFIG = new PluginConfig(Collections.emptyList());
    private List<TppConfig> tppConfigs = new ArrayList<TppConfig>();

    @Nonnull
    public static PluginConfig get() {
        PluginConfig result = (PluginConfig)((Object)PluginConfig.all().get(PluginConfig.class));
        if (result == null) {
            return EMPTY_CONFIG;
        }
        return result;
    }

    public PluginConfig() {
        this.load();
    }

    public PluginConfig(List<TppConfig> tppConfigs) {
        this.tppConfigs = tppConfigs;
    }

    @Nonnull
    public List<TppConfig> getTppConfigs() {
        return this.tppConfigs;
    }

    @Nullable
    public TppConfig getTppConfigByName(String name) {
        for (TppConfig config : this.tppConfigs) {
            if (!config.getName().equals(name)) continue;
            return config;
        }
        return null;
    }

    @DataBoundSetter
    public void setTppConfigs(List<TppConfig> value) {
        this.tppConfigs = value;
    }

    public String getId() {
        return CONFIGURATION_ID;
    }

    protected XmlFile getConfigFile() {
        return new XmlFile((XStream)Jenkins.XSTREAM2, super.getConfigFile().getFile());
    }

    public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
        try {
            req.bindJSON((Object)this, json);
        }
        catch (Exception e) {
            throw new Descriptor.FormException(String.format(Messages.PluginConfig_malformedError(), e.getMessage()), (Throwable)e, CONFIGURATION_ID);
        }
        String duplicateName = this.findDuplicateTppConfigName(this.tppConfigs);
        if (duplicateName != null) {
            throw new Descriptor.FormException(String.format(Messages.PluginConfig_duplicateTppConfigName(), duplicateName), CONFIGURATION_ID);
        }
        this.save();
        return true;
    }

    public String getDisplayName() {
        return Messages.PluginConfig_displayName();
    }

    private String findDuplicateTppConfigName(List<TppConfig> tppConfigs) {
        HashSet<String> namesSeen = new HashSet<String>();
        for (TppConfig config : tppConfigs) {
            if (namesSeen.add(config.getName())) continue;
            return config.getName();
        }
        return null;
    }
}

