/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.venaficodesigning;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.common.UsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.security.ACL;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.venaficodesigning.AgentInfo;
import io.jenkins.plugins.venaficodesigning.Credential;
import io.jenkins.plugins.venaficodesigning.Logger;
import io.jenkins.plugins.venaficodesigning.Messages;
import io.jenkins.plugins.venaficodesigning.PluginConfig;
import io.jenkins.plugins.venaficodesigning.TppConfig;
import io.jenkins.plugins.venaficodesigning.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.RandomStringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class SignToolVerifyBuilder
extends Builder
implements SimpleBuildStep {
    private final String tppName;
    private final String fileOrGlob;
    private final Credential credential;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    private String signToolPath;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    private String venafiClientToolsDir;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    private boolean useMachineConfiguration;

    @DataBoundConstructor
    public SignToolVerifyBuilder(String tppName, String fileOrGlob, Credential credential) {
        this.tppName = tppName;
        this.fileOrGlob = fileOrGlob;
        this.credential = credential;
    }

    public String getTppName() {
        return this.tppName;
    }

    public String getFileOrGlob() {
        return this.fileOrGlob;
    }

    public String getSignToolPath() {
        return this.signToolPath;
    }

    @DataBoundSetter
    public void setSignToolPath(String value) {
        this.signToolPath = value.equals("") ? null : value;
    }

    public String getVenafiClientToolsDir() {
        return this.venafiClientToolsDir;
    }

    @DataBoundSetter
    public void setVenafiClientToolsDir(String value) {
        this.venafiClientToolsDir = value.equals("") ? null : value;
    }

    public boolean getUseMachineConfiguration() {
        return this.useMachineConfiguration;
    }

    @DataBoundSetter
    public void setUseMachineConfiguration(boolean value) {
        this.useMachineConfiguration = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        Logger logger = new Logger(listener.getLogger(), Messages.JarSignerVerifyBuilder_functionName());
        Computer wsComputer = this.getComputer(workspace);
        Node wsNode = this.getNode(wsComputer);
        FilePath nodeRoot = this.getNodeRoot(wsNode);
        TppConfig tppConfig = PluginConfig.get().getTppConfigByName(this.getTppName());
        if (tppConfig == null) {
            throw new AbortException("No Venafi TPP configuration with name '" + this.getTppName() + "' found");
        }
        StandardUsernamePasswordCredentials credentials = this.findCredentialsById(this.credential, run);
        if (credentials == null) {
            throw new AbortException("No credentials with ID '" + this.credential.getCredentialsId() + "' found");
        }
        String sessionID = RandomStringUtils.random((int)24, (boolean)true, (boolean)true);
        AgentInfo agentInfo = (AgentInfo)nodeRoot.act((FilePath.FileCallable)new AgentInfo.GetAgentInfo());
        logger.log("Session ID: %s", sessionID);
        logger.log("Detected node info: %s", agentInfo);
        try {
            this.loginTpp(logger, launcher, workspace, nodeRoot, run, sessionID, agentInfo, tppConfig, credentials);
            this.invokeCspConfigSync(logger, launcher, workspace, sessionID, agentInfo, nodeRoot);
            this.invokeSignToolVerify(logger, launcher, workspace, sessionID, agentInfo, nodeRoot);
        }
        finally {
            this.logoutTpp(logger, launcher, workspace, sessionID, agentInfo, nodeRoot);
        }
    }

    private Computer getComputer(FilePath workspace) throws AbortException {
        Computer result = workspace.toComputer();
        if (result == null) {
            throw new AbortException("Unable to retrieve computer for workspace");
        }
        return result;
    }

    private Node getNode(Computer computer) throws AbortException {
        Node result = computer.getNode();
        if (result == null) {
            throw new AbortException("Unable to retrieve node for workspace");
        }
        return result;
    }

    private FilePath getNodeRoot(Node node) throws AbortException {
        FilePath result = node.getRootPath();
        if (result == null) {
            throw new AbortException("Unable to retrieve root path of node");
        }
        return result;
    }

    StandardUsernamePasswordCredentials findCredentialsById(Credential credential, Run<?, ?> run) {
        return Utils.findCredentialsById(credential.getCredentialsId(), run);
    }

    private void loginTpp(Logger logger, Launcher launcher, FilePath ws, FilePath nodeRoot, Run<?, ?> run, String sessionID, AgentInfo agentInfo, TppConfig tppConfig, StandardUsernamePasswordCredentials credentials) throws InterruptedException, IOException, RuntimeException {
        FilePath cspConfigToolPath = Utils.getCspConfigToolPath(launcher, agentInfo, nodeRoot, this.getVenafiClientToolsDir());
        CredentialsProvider.track(run, (Credentials)credentials);
        String password = Secret.toString((Secret)credentials.getPassword());
        ArrayList<Object> cmdArgs = new ArrayList<Object>();
        cmdArgs.add(cspConfigToolPath.getRemote());
        cmdArgs.add("getgrant");
        if (this.getUseMachineConfiguration()) {
            cmdArgs.add("-machine");
        }
        cmdArgs.add("-force");
        cmdArgs.add("-authurl:" + tppConfig.getAuthUrl());
        cmdArgs.add("-hsmurl:" + tppConfig.getHsmUrl());
        cmdArgs.add("-username:" + credentials.getUsername());
        cmdArgs.add("-password");
        cmdArgs.add(password);
        boolean[] masks = new boolean[cmdArgs.size()];
        for (int i = 0; i < cmdArgs.size() - 1; ++i) {
            masks[i] = false;
        }
        masks[cmdArgs.size() - 1] = true;
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("LIBHSMINSTANCE", sessionID);
        this.invokeCommand(logger, launcher, ws, "Logging into TPP: configuring client: requesting grant from server.", "Successfully obtained grant from TPP.", "Error requesting grant from TPP", "cspconfig getgrant", false, cmdArgs.toArray(new String[0]), masks, envs);
    }

    private void invokeCspConfigSync(Logger logger, Launcher launcher, FilePath ws, String sessionID, AgentInfo agentInfo, FilePath nodeRoot) throws InterruptedException, IOException, RuntimeException {
        FilePath cspConfigToolPath = Utils.getCspConfigToolPath(launcher, agentInfo, nodeRoot, this.getVenafiClientToolsDir());
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(cspConfigToolPath.getRemote());
        cmdArgs.add("sync");
        if (this.getUseMachineConfiguration()) {
            cmdArgs.add("-machine");
        }
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("LIBHSMINSTANCE", sessionID);
        this.invokeCommand(logger, launcher, ws, "Synchronizing local certificate store with TPP.", "Successfully synchronized local certificate store with TPP.", "Error synchronizing local certificate store with TPP", "cspconfig sync", false, cmdArgs.toArray(new String[0]), null, envs);
    }

    private void invokeSignToolVerify(Logger logger, Launcher launcher, FilePath ws, String sessionID, AgentInfo agentInfo, FilePath nodeRoot) throws InterruptedException, IOException {
        String signToolPath = Utils.getSignToolPath(this.getSignToolPath());
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("VENAFICSPSilent", "1");
        envs.put("LIBHSMINSTANCE", sessionID);
        this.invokeCommand(logger, launcher, ws, "Verifying with signtool: " + this.getFileOrGlob(), "Successfully verifying '" + this.getFileOrGlob() + "'.", "Error verifying '" + this.getFileOrGlob() + "'", "signtool", true, new String[]{signToolPath, "verify", "/pa", this.getFileOrGlob()}, null, envs);
    }

    private void logoutTpp(Logger logger, Launcher launcher, FilePath ws, String sessionID, AgentInfo agentInfo, FilePath nodeRoot) {
        try {
            this.invokeCspConfigRevokeGrant(logger, launcher, ws, sessionID, agentInfo, nodeRoot);
        }
        catch (InterruptedException e) {
            logger.log("Error logging out of TPP: operation interrupted.", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace(logger.getOutput());
        }
    }

    private void invokeCspConfigRevokeGrant(Logger logger, Launcher launcher, FilePath ws, String sessionID, AgentInfo agentInfo, FilePath nodeRoot) throws IOException, InterruptedException {
        FilePath cspConfigToolPath = Utils.getCspConfigToolPath(launcher, agentInfo, nodeRoot, this.getVenafiClientToolsDir());
        ArrayList<String> cmdArgs = new ArrayList<String>();
        cmdArgs.add(cspConfigToolPath.getRemote());
        cmdArgs.add("revokegrant");
        if (this.getUseMachineConfiguration()) {
            cmdArgs.add("-machine");
        }
        cmdArgs.add("-force");
        cmdArgs.add("-clear");
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("LIBHSMINSTANCE", sessionID);
        this.invokeCommand(logger, launcher, ws, "Logging out of TPP: revoking server grant.", "Successfully revoked server grant.", "Error revoking grant from TPP", "cspconfig revokegrant", false, cmdArgs.toArray(new String[0]), null, envs);
    }

    private String invokeCommand(Logger logger, Launcher launcher, FilePath ws, String preMessage, String successMessage, String errorMessage, String shortCommandLine, boolean printOutputOnSuccess, String[] cmdArgs, boolean[] masks, Map<String, String> envs) throws InterruptedException, IOException {
        int code;
        logger.log("%s", preMessage);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Launcher.ProcStarter starter = launcher.launch().cmds(cmdArgs).stdout((OutputStream)output).pwd(ws);
        if (masks != null) {
            starter.masks(masks);
        }
        if (envs != null) {
            starter.envs(envs);
        }
        try {
            Proc proc = starter.start();
            code = proc.join();
        }
        catch (IOException e) {
            logger.log("%s: %s", errorMessage, e.getMessage());
            throw e;
        }
        String outputString = output.toString("UTF-8").trim();
        if (code == 0) {
            if (printOutputOnSuccess) {
                logger.log("%s", outputString);
            }
            logger.log("%s", successMessage);
            return outputString;
        }
        logger.log("%s: command exited with code %d. Output from command '%s' is as follows:\n%s", errorMessage, code, shortCommandLine, outputString);
        throw new AbortException(errorMessage + ": command exited with code " + code);
    }

    @Symbol(value={"venafiVerifyWithSignTool"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.SignToolVerifyBuilder_displayName();
        }

        public ListBoxModel doFillTppNameItems() {
            ListBoxModel items = new ListBoxModel();
            for (TppConfig config : PluginConfig.get().getTppConfigs()) {
                items.add(config.getName(), config.getName());
            }
            return items;
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null ? !Jenkins.get().hasPermission(Jenkins.ADMINISTER) : !item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeMatchingAs(ACL.SYSTEM, item, StandardCredentials.class, new ArrayList(), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(UsernamePasswordCredentials.class)})).includeCurrentValue(credentialsId);
        }

        public FormValidation doCheckFileOrGlob(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }
    }
}

