/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.venaficodesigning;

import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.Computer;
import hudson.model.Item;
import hudson.security.ACL;
import io.jenkins.plugins.venaficodesigning.AgentInfo;
import io.jenkins.plugins.venaficodesigning.Logger;
import io.jenkins.plugins.venaficodesigning.OsType;
import io.jenkins.plugins.venaficodesigning.RealCommandLauncher;
import io.jenkins.plugins.venaficodesigning.WindowsRegistry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import javax.annotation.Nullable;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class Utils {
    @Nullable
    public static StandardUsernamePasswordCredentials findCredentials(String credentialsId) {
        return Utils.findCredentials(credentialsId, null);
    }

    @Nullable
    public static StandardUsernamePasswordCredentials findCredentials(String credentialsId, Item item) {
        if (StringUtils.isBlank((String)credentialsId)) {
            return null;
        }
        return (StandardUsernamePasswordCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentials(StandardUsernamePasswordCredentials.class, (Item)item, (Authentication)ACL.SYSTEM, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)credentialsId), CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class)})}));
    }

    public static String getFqdn(Computer computer, Launcher launcher, AgentInfo agentInfo) throws IOException, InterruptedException {
        String result = computer.getHostName();
        if (result != null) {
            return result;
        }
        if (!agentInfo.osType.isUnixCompatible()) {
            return "";
        }
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Launcher.ProcStarter starter = launcher.launch().cmds(new String[]{"hostname", "-f"}).stdout((OutputStream)output).quiet(true);
        Proc proc = starter.start();
        int code = proc.join();
        if (code == 0) {
            return output.toString("UTF-8").trim();
        }
        throw new IOException("Error determining node's FQDN: command 'hostname -f' exited with code " + code);
    }

    public static void deleteFileOrPrintStackTrace(Logger logger, FilePath file) {
        try {
            if (file != null) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace(logger.getOutput());
        }
    }

    public static void deleteFileRecursiveOrPrintStackTrace(Logger logger, FilePath file) {
        try {
            if (file != null) {
                file.deleteRecursive();
            }
        }
        catch (Exception e) {
            e.printStackTrace(logger.getOutput());
        }
    }

    public static FilePath detectVenafiClientToolsDir(Launcher launcher, AgentInfo agentInfo, FilePath nodeRoot, String userProvidedVenafiClientToolsDir) throws InterruptedException, IOException {
        if (userProvidedVenafiClientToolsDir != null) {
            return nodeRoot.child(userProvidedVenafiClientToolsDir);
        }
        if (agentInfo.osType == OsType.MACOS) {
            return nodeRoot.child("/Library/Venafi/CodeSigning");
        }
        if (agentInfo.osType == OsType.WINDOWS) {
            WindowsRegistry registry = new WindowsRegistry(new RealCommandLauncher(launcher), agentInfo.isWindows64Bit);
            String result = registry.readKey("HKLM\\Software\\Venafi\\Platform", "Client Base Path");
            if (result != null) {
                return nodeRoot.child(result);
            }
            String programFiles = System.getenv("ProgramFiles");
            if (programFiles == null) {
                programFiles = "C:\\Program Files";
            }
            return nodeRoot.child(programFiles).child("Venafi CodeSign Protect");
        }
        return nodeRoot.child("/opt/venafi/codesign");
    }

    public static FilePath getPkcs11DriverLibraryPath(Launcher launcher, AgentInfo agentInfo, FilePath nodeRoot, String userProvidedVenafiClientToolsDir) throws InterruptedException, IOException {
        FilePath toolsDir = Utils.detectVenafiClientToolsDir(launcher, agentInfo, nodeRoot, userProvidedVenafiClientToolsDir);
        if (agentInfo.osType == OsType.WINDOWS) {
            return toolsDir.child("PKCS11").child(agentInfo.isJre64Bit ? "VenafiPKCS11.dll" : "VenafiPKCS11-x86.dll");
        }
        return toolsDir.child("lib").child("venafipkcs11.so");
    }

    public static FilePath getPkcs11ConfigToolPath(Launcher launcher, AgentInfo agentInfo, FilePath nodeRoot, String venafiCodeSigningInstallDir) throws InterruptedException, IOException {
        FilePath toolsDir = Utils.detectVenafiClientToolsDir(launcher, agentInfo, nodeRoot, venafiCodeSigningInstallDir);
        if (agentInfo.osType == OsType.WINDOWS) {
            String exe = agentInfo.isJre64Bit ? "PKCS11Config.exe" : "PKCS11Config-x86.exe";
            return toolsDir.child(exe);
        }
        return toolsDir.child("bin").child("pkcs11config");
    }

    public static void createPkcs11ProviderConfig(Launcher launcher, AgentInfo agentInfo, FilePath nodeRoot, FilePath file, String userProvidedVenafiClientToolsDir) throws IOException, InterruptedException {
        String libpath = Utils.getPkcs11DriverLibraryPath(launcher, agentInfo, nodeRoot, userProvidedVenafiClientToolsDir).getRemote();
        String contents = String.format("name = VenafiPKCS11%nlibrary = \"%s\"%nslot = 0%n", StringEscapeUtils.escapeJava((String)libpath));
        file.write(contents, "UTF-8");
    }

    public static FilePath getCspConfigToolPath(Launcher launcher, AgentInfo agentInfo, FilePath nodeRoot, String userProvidedVenafiClientToolsDir) throws InterruptedException, IOException {
        String cspConfigExe = agentInfo.isWindows64Bit ? "CSPConfig.exe" : "CSPConfig-x86.exe";
        FilePath toolsDir = Utils.detectVenafiClientToolsDir(launcher, agentInfo, nodeRoot, userProvidedVenafiClientToolsDir);
        return toolsDir.child(cspConfigExe);
    }

    public static String getSignToolPath(String userProvidedSignToolPath) {
        if (userProvidedSignToolPath != null) {
            return userProvidedSignToolPath;
        }
        return "signtool";
    }
}

