/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.venaficodesigning;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.venaficodesigning.AgentInfo;
import io.jenkins.plugins.venaficodesigning.Logger;
import io.jenkins.plugins.venaficodesigning.Messages;
import io.jenkins.plugins.venaficodesigning.PluginConfig;
import io.jenkins.plugins.venaficodesigning.TppConfig;
import io.jenkins.plugins.venaficodesigning.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.RandomStringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class JarSignerVerifyBuilder
extends Builder
implements SimpleBuildStep {
    private final String tppName;
    private final String certLabel;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    private String file;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    private String glob;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    private String venafiClientToolsDir;

    @DataBoundConstructor
    public JarSignerVerifyBuilder(String tppName, String certLabel) {
        this.tppName = tppName;
        this.certLabel = certLabel;
    }

    public String getTppName() {
        return this.tppName;
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String value) {
        this.file = value.equals("") ? null : value;
    }

    public String getGlob() {
        return this.glob;
    }

    @DataBoundSetter
    public void setGlob(String value) {
        this.glob = value.equals("") ? null : value;
    }

    public String getCertLabel() {
        return this.certLabel;
    }

    public String getVenafiClientToolsDir() {
        return this.venafiClientToolsDir;
    }

    @DataBoundSetter
    public void setVenafiClientToolsDir(String value) {
        this.venafiClientToolsDir = value.equals("") ? null : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        Logger logger = new Logger(listener.getLogger(), Messages.JarSignerVerifyBuilder_functionName());
        Computer wsComputer = this.getComputer(workspace);
        Node wsNode = this.getNode(wsComputer);
        FilePath nodeRoot = this.getNodeRoot(wsNode);
        TppConfig tppConfig = this.getTppConfigByName(this.getTppName());
        if (tppConfig == null) {
            throw new AbortException("No Venafi TPP configuration with name '" + this.getTppName() + "' found");
        }
        StandardUsernamePasswordCredentials credentials = this.findCredentials(tppConfig);
        if (credentials == null) {
            throw new AbortException("No credentials with ID '" + tppConfig.getCredentialsId() + "' found");
        }
        String sessionID = RandomStringUtils.random((int)24, (boolean)true, (boolean)true);
        AgentInfo agentInfo = (AgentInfo)nodeRoot.act((FilePath.FileCallable)new AgentInfo.GetAgentInfo());
        logger.log("Session ID: %s", sessionID);
        logger.log("Detected node info: %s", agentInfo);
        FilePath tempDir = null;
        try {
            tempDir = workspace.createTempDir("jarsigner-verify", "");
            Collection<FilePath> filesToVerify = this.getFilesToVerify(workspace);
            FilePath certFile = tempDir.child("cert.crt");
            FilePath chainFile = tempDir.child("chain.crt");
            FilePath keystore = tempDir.child("keystore");
            this.loginTpp(logger, launcher, workspace, nodeRoot, run, sessionID, agentInfo, tppConfig, credentials);
            this.getCertificates(logger, launcher, workspace, nodeRoot, sessionID, agentInfo, certFile, chainFile);
            this.importCertificates(logger, launcher, workspace, nodeRoot, sessionID, agentInfo, certFile, chainFile, keystore, tempDir);
            this.invokeJarSignerVerify(logger, launcher, workspace, agentInfo, keystore, filesToVerify);
        }
        finally {
            this.logoutTpp(logger, launcher, workspace, nodeRoot, sessionID, agentInfo);
            Utils.deleteFileRecursiveOrPrintStackTrace(logger, tempDir);
        }
    }

    private Computer getComputer(FilePath workspace) throws AbortException {
        Computer result = workspace.toComputer();
        if (result == null) {
            throw new AbortException("Unable to retrieve computer for workspace");
        }
        return result;
    }

    private Node getNode(Computer computer) throws AbortException {
        Node result = computer.getNode();
        if (result == null) {
            throw new AbortException("Unable to retrieve node for workspace");
        }
        return result;
    }

    private FilePath getNodeRoot(Node node) throws AbortException {
        FilePath result = node.getRootPath();
        if (result == null) {
            throw new AbortException("Unable to retrieve root path of node");
        }
        return result;
    }

    TppConfig getTppConfigByName(String name) {
        return PluginConfig.get().getTppConfigByName(name);
    }

    StandardUsernamePasswordCredentials findCredentials(TppConfig tppConfig) {
        return Utils.findCredentials(tppConfig.getCredentialsId());
    }

    private Collection<FilePath> getFilesToVerify(FilePath ws) throws IOException, InterruptedException {
        ArrayList<FilePath> result = new ArrayList<FilePath>();
        if (this.getFile() != null) {
            result.add(ws.child(this.getFile()));
        } else {
            for (FilePath path : ws.list(this.getGlob(), null, false)) {
                result.add(path);
            }
        }
        return result;
    }

    private void loginTpp(Logger logger, Launcher launcher, FilePath ws, FilePath nodeRoot, Run<?, ?> run, String sessionID, AgentInfo agentInfo, TppConfig tppConfig, StandardUsernamePasswordCredentials credentials) throws InterruptedException, IOException, RuntimeException {
        this.invokePkcs11ConfigGetGrant(logger, launcher, ws, nodeRoot, run, tppConfig, sessionID, agentInfo, credentials);
    }

    private void invokePkcs11ConfigGetGrant(Logger logger, Launcher launcher, FilePath ws, FilePath nodeRoot, Run<?, ?> run, TppConfig tppConfig, String sessionID, AgentInfo agentInfo, StandardUsernamePasswordCredentials credentials) throws InterruptedException, IOException {
        FilePath pkcs11ConfigToolPath = Utils.getPkcs11ConfigToolPath(launcher, agentInfo, nodeRoot, this.getVenafiClientToolsDir());
        CredentialsProvider.track(run, (Credentials)credentials);
        String password = Secret.toString((Secret)credentials.getPassword());
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("LIBHSMINSTANCE", sessionID);
        this.invokeCommand(logger, launcher, ws, "Logging into TPP: configuring client: requesting grant from server.", "Successfully obtained grant from TPP.", "Error requesting grant from TPP", "pkcs11config getgrant", false, new String[]{pkcs11ConfigToolPath.getRemote(), "getgrant", "--force", "--authurl=" + tppConfig.getAuthUrl(), "--hsmurl=" + tppConfig.getHsmUrl(), "--username=" + credentials.getUsername(), "--password", password}, new boolean[]{false, false, false, false, false, false, false, true}, envs);
    }

    private void getCertificates(Logger logger, Launcher launcher, FilePath ws, FilePath nodeRoot, String sessionID, AgentInfo agentInfo, FilePath certFile, FilePath chainFile) throws InterruptedException, IOException {
        FilePath pkcs11ConfigToolPath = Utils.getPkcs11ConfigToolPath(launcher, agentInfo, nodeRoot, this.getVenafiClientToolsDir());
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("LIBHSMINSTANCE", sessionID);
        this.invokeCommand(logger, launcher, ws, "Getting certificate chain from TPP.", "Successfully obtained certificate chain from TPP.", "Error obtaining certificate chain from TPP", "pkcs11config getcertificate", false, new String[]{pkcs11ConfigToolPath.getRemote(), "getcertificate", "--label=" + this.getCertLabel(), "--file=" + certFile.getRemote(), "--chainfile=" + chainFile.getRemote()}, null, envs);
    }

    private void importCertificates(Logger logger, Launcher launcher, FilePath ws, FilePath nodeRoot, String sessionID, AgentInfo agentInfo, FilePath certFile, FilePath chainFile, FilePath keystore, FilePath tempDir) throws InterruptedException, IOException {
        this.invokeCommand(logger, launcher, ws, "Importing main certificate into temporary Java key store.", "Successfully imported main certificate into temporary Java key store.", "Error importing main certificate into temporary Java key store", "keytool -import", false, new String[]{"keytool", "-import", "-trustcacerts", "-file", certFile.getRemote(), "-alias", certFile.getRemote(), "-keystore", keystore.getRemote(), "--storepass", "notrelevant", "--noprompt"}, null, null);
        List<String> chainParts = this.splitCertChain(chainFile.readToString());
        int i = 1;
        for (String chainPart : chainParts) {
            FilePath chainPartFile = tempDir.child("chain." + Integer.toString(i) + ".crt");
            chainPartFile.write(chainPart, "UTF-8");
            this.invokeCommand(logger, launcher, ws, String.format("Importing certificate chain [part %d] into temporary Java key store.", i), String.format("Successfully imported certificate chain [part %d] into temporary Java key store.", i), String.format("Error importing certificate chain [part %d] into temporary Java key store", i), "keytool -import", false, new String[]{"keytool", "-import", "-trustcacerts", "-file", chainPartFile.getRemote(), "-alias", chainPartFile.getRemote(), "-keystore", keystore.getRemote(), "--storepass", "notrelevant", "--noprompt"}, null, null);
            ++i;
        }
    }

    private List<String> splitCertChain(String chainCertData) {
        String[] lines = chainCertData.split("\r?\n");
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder currentCert = new StringBuilder();
        for (String line : lines) {
            if (line.isEmpty()) continue;
            currentCert.append(line);
            currentCert.append("\n");
            if (line.indexOf("-END CERTIFICATE-") == -1) continue;
            result.add(currentCert.toString());
            currentCert = new StringBuilder();
        }
        return result;
    }

    private void logoutTpp(Logger logger, Launcher launcher, FilePath ws, FilePath nodeRoot, String sessionID, AgentInfo agentInfo) {
        try {
            this.invokePkcs11ConfigRevokeGrant(logger, launcher, ws, nodeRoot, sessionID, agentInfo);
        }
        catch (InterruptedException e) {
            logger.log("Error logging out of TPP: operation interrupted.", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace(logger.getOutput());
        }
    }

    private void invokePkcs11ConfigRevokeGrant(Logger logger, Launcher launcher, FilePath ws, FilePath nodeRoot, String sessionID, AgentInfo agentInfo) throws IOException, InterruptedException {
        FilePath pkcs11ConfigToolPath = Utils.getPkcs11ConfigToolPath(launcher, agentInfo, nodeRoot, this.getVenafiClientToolsDir());
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("LIBHSMINSTANCE", sessionID);
        this.invokeCommand(logger, launcher, ws, "Logging out of TPP: revoking server grant.", "Successfully revoked server grant.", "Error revoking grant from TPP", "pkcs11config revokegrant", false, new String[]{pkcs11ConfigToolPath.getRemote(), "revokegrant", "-force", "-clear"}, null, envs);
    }

    private void invokeJarSignerVerify(Logger logger, Launcher launcher, FilePath ws, AgentInfo agentInfo, FilePath keystore, Collection<FilePath> filesToVerify) throws InterruptedException, IOException {
        for (FilePath fileToVerify : filesToVerify) {
            String output = this.invokeCommand(logger, launcher, ws, "Verifying with jarsigner: " + fileToVerify.getRemote(), null, "Error verifying '" + fileToVerify.getRemote() + "'", "jarsigner -verify", true, new String[]{"jarsigner", "-verify", "-verbose", "-keystore", keystore.getRemote(), fileToVerify.getRemote()}, null, null);
            if (output.indexOf("jar is unsigned") == -1) {
                logger.log("Successfully verified '" + fileToVerify.getRemote() + "'.", new Object[0]);
                continue;
            }
            throw new AbortException("Verification of '" + fileToVerify.getRemote() + "' failed: file is unsigned");
        }
    }

    private String invokeCommand(Logger logger, Launcher launcher, FilePath ws, String preMessage, String successMessage, String errorMessage, String shortCommandLine, boolean printOutputOnSuccess, String[] cmdArgs, boolean[] masks, Map<String, String> envs) throws InterruptedException, IOException {
        int code;
        logger.log("%s", preMessage);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Launcher.ProcStarter starter = launcher.launch().cmds(cmdArgs).stdout((OutputStream)output).pwd(ws);
        if (masks != null) {
            starter.masks(masks);
        }
        if (envs != null) {
            starter.envs(envs);
        }
        try {
            Proc proc = starter.start();
            code = proc.join();
        }
        catch (IOException e) {
            logger.log("%s: %s", errorMessage, e.getMessage());
            throw e;
        }
        String outputString = output.toString("UTF-8").trim();
        if (code == 0) {
            if (printOutputOnSuccess) {
                logger.log("%s", outputString);
            }
            if (successMessage != null) {
                logger.log("%s", successMessage);
            }
            return outputString;
        }
        logger.log("%s: command exited with code %d. Output from command '%s' is as follows:\n%s", errorMessage, code, shortCommandLine, outputString);
        throw new AbortException(errorMessage + ": command exited with code " + code);
    }

    @Symbol(value={"venafiVerifyWithJarSigner"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.JarSignerVerifyBuilder_displayName();
        }

        public ListBoxModel doFillTppNameItems() {
            ListBoxModel items = new ListBoxModel();
            for (TppConfig config : PluginConfig.get().getTppConfigs()) {
                items.add(config.getName(), config.getName());
            }
            return items;
        }

        public FormValidation doCheckFile(@QueryParameter String value, @QueryParameter String glob) {
            if (glob.isEmpty()) {
                return FormValidation.validateRequired((String)value);
            }
            if (!value.isEmpty()) {
                return FormValidation.error((String)Messages.JarSignerVerifyBuilder_fileAndGlobMutuallyExclusive());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckGlob(@QueryParameter String value, @QueryParameter String file) {
            if (file.isEmpty()) {
                return FormValidation.validateRequired((String)value);
            }
            if (!value.isEmpty()) {
                return FormValidation.error((String)Messages.JarSignerVerifyBuilder_fileAndGlobMutuallyExclusive());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCertLabel(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }
    }
}

