/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.venaficodesigning;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.AbortException;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import io.jenkins.plugins.venaficodesigning.AgentInfo;
import io.jenkins.plugins.venaficodesigning.CmdArg;
import io.jenkins.plugins.venaficodesigning.Logger;
import io.jenkins.plugins.venaficodesigning.Messages;
import io.jenkins.plugins.venaficodesigning.PluginConfig;
import io.jenkins.plugins.venaficodesigning.TimestampingServer;
import io.jenkins.plugins.venaficodesigning.TppConfig;
import io.jenkins.plugins.venaficodesigning.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.apache.commons.lang.RandomStringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class JarSignerBuilder
extends Builder
implements SimpleBuildStep {
    private final String tppName;
    private final String certLabel;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    private String file;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    private String glob;
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    private List<TimestampingServer> timestampingServers = new ArrayList<TimestampingServer>();
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    private List<CmdArg> extraArgs = new ArrayList<CmdArg>();
    @SuppressFBWarnings(value={"UUF_UNUSED_FIELD"})
    private String venafiClientToolsDir;

    @DataBoundConstructor
    public JarSignerBuilder(String tppName, String certLabel) {
        this.tppName = tppName;
        this.certLabel = certLabel;
    }

    public String getTppName() {
        return this.tppName;
    }

    public String getFile() {
        return this.file;
    }

    @DataBoundSetter
    public void setFile(String value) {
        this.file = value.equals("") ? null : value;
    }

    public String getGlob() {
        return this.glob;
    }

    @DataBoundSetter
    public void setGlob(String value) {
        this.glob = value.equals("") ? null : value;
    }

    public String getCertLabel() {
        return this.certLabel;
    }

    public List<TimestampingServer> getTimestampingServers() {
        return this.timestampingServers;
    }

    @DataBoundSetter
    public void setTimestampingServers(List<TimestampingServer> value) {
        this.timestampingServers = value;
    }

    public List<CmdArg> getExtraArgs() {
        return this.extraArgs;
    }

    @DataBoundSetter
    public void setExtraArgs(List<CmdArg> value) {
        this.extraArgs = value;
    }

    public String getVenafiClientToolsDir() {
        return this.venafiClientToolsDir;
    }

    @DataBoundSetter
    public void setVenafiClientToolsDir(String value) {
        this.venafiClientToolsDir = value.equals("") ? null : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void perform(Run<?, ?> run, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        Logger logger = new Logger(listener.getLogger(), Messages.JarSignerBuilder_functionName());
        Computer wsComputer = workspace.toComputer();
        if (wsComputer == null) {
            throw new AbortException("Unable to retrieve computer for workspace");
        }
        Node wsNode = wsComputer.getNode();
        if (wsNode == null) {
            throw new AbortException("Unable to retrieve node for workspace");
        }
        FilePath nodeRoot = wsNode.getRootPath();
        if (nodeRoot == null) {
            throw new AbortException("Unable to retrieve root path of node");
        }
        TppConfig tppConfig = this.getTppConfigByName(this.getTppName());
        if (tppConfig == null) {
            throw new AbortException("No Venafi TPP configuration with name '" + this.getTppName() + "' found");
        }
        StandardUsernamePasswordCredentials credentials = this.findCredentials(tppConfig);
        if (credentials == null) {
            throw new AbortException("No credentials with ID '" + tppConfig.getCredentialsId() + "' found");
        }
        String sessionID = RandomStringUtils.random((int)24, (boolean)true, (boolean)true);
        AgentInfo agentInfo = (AgentInfo)nodeRoot.act((FilePath.FileCallable)new AgentInfo.GetAgentInfo());
        logger.log("Session ID: %s", sessionID);
        logger.log("Detected node info: %s", agentInfo);
        FilePath pkcs11ProviderConfigFile = null;
        try {
            Collection<FilePath> filesToSign = this.getFilesToSign(workspace);
            pkcs11ProviderConfigFile = workspace.createTempFile("pkcs11-provider", ".conf");
            Utils.createPkcs11ProviderConfig(launcher, agentInfo, nodeRoot, pkcs11ProviderConfigFile, this.getVenafiClientToolsDir());
            this.loginTpp(logger, launcher, workspace, nodeRoot, run, sessionID, agentInfo, tppConfig, credentials);
            this.invokeJarSigner(logger, launcher, workspace, sessionID, agentInfo, pkcs11ProviderConfigFile, filesToSign);
        }
        finally {
            this.logoutTpp(logger, launcher, workspace, nodeRoot, sessionID, agentInfo);
            Utils.deleteFileOrPrintStackTrace(logger, pkcs11ProviderConfigFile);
        }
    }

    TppConfig getTppConfigByName(String name) {
        return PluginConfig.get().getTppConfigByName(name);
    }

    StandardUsernamePasswordCredentials findCredentials(TppConfig tppConfig) {
        return Utils.findCredentials(tppConfig.getCredentialsId());
    }

    private void loginTpp(Logger logger, Launcher launcher, FilePath ws, FilePath nodeRoot, Run<?, ?> run, String sessionID, AgentInfo agentInfo, TppConfig tppConfig, StandardUsernamePasswordCredentials credentials) throws InterruptedException, IOException, RuntimeException {
        this.invokePkcs11ConfigGetGrant(logger, launcher, ws, nodeRoot, run, tppConfig, sessionID, agentInfo, credentials);
    }

    private void invokePkcs11ConfigGetGrant(Logger logger, Launcher launcher, FilePath ws, FilePath nodeRoot, Run<?, ?> run, TppConfig tppConfig, String sessionID, AgentInfo agentInfo, StandardUsernamePasswordCredentials credentials) throws InterruptedException, IOException {
        FilePath pkcs11ConfigToolPath = Utils.getPkcs11ConfigToolPath(launcher, agentInfo, nodeRoot, this.getVenafiClientToolsDir());
        CredentialsProvider.track(run, (Credentials)credentials);
        String password = Secret.toString((Secret)credentials.getPassword());
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("LIBHSMINSTANCE", sessionID);
        this.invokeCommand(logger, launcher, ws, "Logging into TPP: configuring client: requesting grant from server.", "Successfully obtained grant from TPP.", "Error requesting grant from TPP", "pkcs11config getgrant", new String[]{pkcs11ConfigToolPath.getRemote(), "getgrant", "--force", "--authurl=" + tppConfig.getAuthUrl(), "--hsmurl=" + tppConfig.getHsmUrl(), "--username=" + credentials.getUsername(), "--password", password}, new boolean[]{false, false, false, false, false, false, false, true}, envs);
    }

    private void logoutTpp(Logger logger, Launcher launcher, FilePath ws, FilePath nodeRoot, String sessionID, AgentInfo agentInfo) {
        try {
            this.invokePkcs11ConfigRevokeGrant(logger, launcher, ws, nodeRoot, sessionID, agentInfo);
        }
        catch (InterruptedException e) {
            logger.log("Error logging out of TPP: operation interrupted.", new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace(logger.getOutput());
        }
    }

    private void invokePkcs11ConfigRevokeGrant(Logger logger, Launcher launcher, FilePath ws, FilePath nodeRoot, String sessionID, AgentInfo agentInfo) throws IOException, InterruptedException {
        FilePath pkcs11ConfigToolPath = Utils.getPkcs11ConfigToolPath(launcher, agentInfo, nodeRoot, this.getVenafiClientToolsDir());
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("LIBHSMINSTANCE", sessionID);
        this.invokeCommand(logger, launcher, ws, "Logging out of TPP: revoking server grant.", "Successfully revoked server grant.", "Error revoking grant from TPP", "pkcs11config revokegrant", new String[]{pkcs11ConfigToolPath.getRemote(), "revokegrant", "-force", "-clear"}, null, envs);
    }

    private Collection<FilePath> getFilesToSign(FilePath ws) throws IOException, InterruptedException {
        ArrayList<FilePath> result = new ArrayList<FilePath>();
        if (this.getFile() != null) {
            result.add(ws.child(this.getFile()));
        } else {
            for (FilePath path : ws.list(this.getGlob(), null, false)) {
                result.add(path);
            }
        }
        return result;
    }

    private void invokeJarSigner(Logger logger, Launcher launcher, FilePath ws, String sessionID, AgentInfo agentInfo, FilePath pkcs11ProviderConfigFile, Collection<FilePath> filesToSign) throws InterruptedException, IOException {
        HashMap<String, String> envs = new HashMap<String, String>();
        envs.put("LIBHSMINSTANCE", sessionID);
        for (FilePath fileToSign : filesToSign) {
            ArrayList<String> cmdArgs = new ArrayList<String>();
            cmdArgs.add("jarsigner");
            cmdArgs.add("-verbose");
            cmdArgs.add("-keystore");
            cmdArgs.add("NONE");
            cmdArgs.add("-storetype");
            cmdArgs.add("PKCS11");
            cmdArgs.add("-storepass");
            cmdArgs.add("none");
            cmdArgs.add("-providerclass");
            cmdArgs.add("sun.security.pkcs11.SunPKCS11");
            cmdArgs.add("-providerArg");
            cmdArgs.add(pkcs11ProviderConfigFile.getRemote());
            cmdArgs.add("-certs");
            if (!this.getTimestampingServers().isEmpty()) {
                TimestampingServer timestampingServer = this.getTimestampingServers().get((int)(Math.random() * (double)this.getTimestampingServers().size()));
                cmdArgs.add("-tsa");
                cmdArgs.add(timestampingServer.getAddress());
            }
            for (CmdArg extraArg : this.getExtraArgs()) {
                cmdArgs.add(extraArg.getArgument());
            }
            cmdArgs.add(fileToSign.getRemote());
            cmdArgs.add(this.getCertLabel());
            this.invokeCommand(logger, launcher, ws, "Signing with jarsigner: " + fileToSign.getRemote(), "Successfully signed '" + fileToSign.getRemote() + "'.", "Error signing '" + fileToSign.getRemote() + "'", "jarsigner", cmdArgs.toArray(new String[0]), null, envs);
        }
    }

    private String invokeCommand(Logger logger, Launcher launcher, FilePath ws, String preMessage, String successMessage, String errorMessage, String shortCommandLine, String[] cmdArgs, boolean[] masks, Map<String, String> envs) throws InterruptedException, IOException {
        int code;
        logger.log("%s", preMessage);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        Launcher.ProcStarter starter = launcher.launch().cmds(cmdArgs).stdout((OutputStream)output).pwd(ws);
        if (masks != null) {
            starter.masks(masks);
        }
        if (envs != null) {
            starter.envs(envs);
        }
        try {
            code = this.startAndJoinProc(starter);
        }
        catch (IOException e) {
            logger.log("%s: %s", errorMessage, e.getMessage());
            throw e;
        }
        if (code == 0) {
            logger.log("%s", successMessage);
            return output.toString("UTF-8");
        }
        logger.log("%s: command exited with code %d. Output from command '%s' is as follows:\n%s", errorMessage, code, shortCommandLine, output.toString("UTF-8"));
        throw new AbortException(errorMessage + ": command exited with code " + code);
    }

    int startAndJoinProc(Launcher.ProcStarter starter) throws IOException, InterruptedException {
        return starter.start().join();
    }

    @Symbol(value={"venafiCodeSignWithJarSigner"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.JarSignerBuilder_displayName();
        }

        public ListBoxModel doFillTppNameItems() {
            ListBoxModel items = new ListBoxModel();
            for (TppConfig config : PluginConfig.get().getTppConfigs()) {
                items.add(config.getName(), config.getName());
            }
            return items;
        }

        public FormValidation doCheckFile(@QueryParameter String value, @QueryParameter String glob) {
            if (glob.isEmpty()) {
                return FormValidation.validateRequired((String)value);
            }
            if (!value.isEmpty()) {
                return FormValidation.error((String)Messages.JarSignerBuilder_fileAndGlobMutuallyExclusive());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckGlob(@QueryParameter String value, @QueryParameter String file) {
            if (file.isEmpty()) {
                return FormValidation.validateRequired((String)value);
            }
            if (!value.isEmpty()) {
                return FormValidation.error((String)Messages.JarSignerBuilder_fileAndGlobMutuallyExclusive());
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckCertLabel(@QueryParameter String value) {
            return FormValidation.validateRequired((String)value);
        }
    }
}

