/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.venaficodesigning;

import hudson.Launcher;
import io.jenkins.plugins.venaficodesigning.CommandLauncher;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.annotation.Nonnull;

public class RealCommandLauncher
implements CommandLauncher {
    @Nonnull
    private Launcher jenkinsLauncher;
    @Nonnull
    private Launcher.ProcStarter starter;
    private ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
    private int code = -1;

    public RealCommandLauncher(@Nonnull Launcher jenkinsLauncher) {
        this.jenkinsLauncher = jenkinsLauncher;
        this.starter = jenkinsLauncher.launch().stdout((OutputStream)this.outputStream);
    }

    @Override
    public CommandLauncher cmds(String ... args) {
        this.starter.cmds(args);
        return this;
    }

    @Override
    public CommandLauncher envs(@Nonnull Map<String, String> overrides) {
        this.starter.envs(overrides);
        return this;
    }

    @Override
    public CommandLauncher masks(boolean ... values) {
        this.starter.masks(values);
        return this;
    }

    @Override
    public CommandLauncher quiet(boolean value) {
        this.starter.quiet(value);
        return this;
    }

    @Override
    public CommandLauncher pwd(@Nonnull String path) {
        this.starter.pwd(path);
        return this;
    }

    @Override
    public void startAndJoin() throws IOException, InterruptedException {
        this.code = this.starter.start().join();
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getOutput() {
        try {
            return this.outputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

