/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.venaficodesigning;

import hudson.FilePath;
import hudson.Platform;
import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.venaficodesigning.OsType;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.jenkinsci.remoting.RoleChecker;

public final class AgentInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    public String username;
    public OsType osType;
    public boolean isJre64Bit;
    public boolean isWindows64Bit;

    public String toString() {
        String result = String.format("OS=%s, JRE=%s", new Object[]{this.osType, this.isJre64Bit ? "64-bit" : "32-bit"});
        if (this.osType == OsType.WINDOWS) {
            result = result + ", Windows=" + (this.isWindows64Bit ? "64-bit" : "32-bit");
        }
        return result;
    }

    public static final class GetAgentInfo
    implements FilePath.FileCallable<AgentInfo> {
        private static final long serialVersionUID = 1L;

        public AgentInfo invoke(File nodeRoot, VirtualChannel virtualChannel) throws IOException, InterruptedException {
            AgentInfo info = new AgentInfo();
            info.username = System.getProperty("user.name");
            boolean bl = info.isJre64Bit = !System.getProperty("os.arch").equals("x86");
            if (Platform.isDarwin()) {
                info.osType = OsType.MACOS;
            } else if (Platform.current() == Platform.WINDOWS) {
                info.osType = OsType.WINDOWS;
                info.isWindows64Bit = System.getenv("ProgramFiles(x86)") != null;
            } else {
                info.osType = OsType.GENERIC_UNIX;
            }
            return info;
        }

        public void checkRoles(RoleChecker roleChecker) throws SecurityException {
        }
    }
}

