/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.jenkins.plugins.unleash.util;

import com.google.common.base.Optional;
import hudson.FilePath;
import hudson.maven.MavenModule;
import hudson.maven.MavenModuleSet;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;

public final class MavenUtil {
    private MavenUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Optional<Model> parseModel(MavenModule module, MavenModuleSet mavenModuleSet) {
        if (module == null || mavenModuleSet == null || mavenModuleSet.getRootModule() == null) {
            return Optional.absent();
        }
        Object pathToPom = mavenModuleSet.getRootModule().equals(module) ? mavenModuleSet.getRootPOM(null) : module.getRelativePath() + "/pom.xml";
        Model model = null;
        InputStream modelIS = null;
        try {
            FilePath workSpace = mavenModuleSet.getSomeWorkspace();
            if (workSpace != null) {
                modelIS = workSpace.child((String)pathToPom).read();
                model = new MavenXpp3Reader().read(modelIS);
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            if (modelIS != null) {
                try {
                    modelIS.close();
                }
                catch (IOException iOException) {}
            }
        }
        return Optional.fromNullable(model);
    }

    public static Optional<String> parseVersion(Model model) {
        Parent parent;
        String version = model.getVersion();
        if (version == null && (parent = model.getParent()) != null) {
            version = parent.getVersion();
        }
        return Optional.fromNullable((Object)version);
    }
}

