/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.jenkins.plugins.unleash;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.AbstractIdCredentialsListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.itemis.jenkins.plugins.unleash.HookDescriptor;
import com.itemis.jenkins.plugins.unleash.UnleashAction;
import com.itemis.jenkins.plugins.unleash.UnleashArgumentInterceptorAction;
import com.itemis.jenkins.plugins.unleash.UnleashArgumentsAction;
import com.itemis.jenkins.plugins.unleash.UnleashBadgeAction;
import com.itemis.jenkins.plugins.unleash.UnleashCause;
import com.itemis.jenkins.plugins.unleash.util.MavenUtil;
import com.itemis.maven.plugins.unleash.util.MavenVersionUtil;
import com.itemis.maven.plugins.unleash.util.VersionUpgradeStrategy;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Launcher;
import hudson.maven.AbstractMavenProject;
import hudson.maven.MavenModuleSet;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Queue;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.tasks.BuildWrapper;
import hudson.tasks.BuildWrapperDescriptor;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Model;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;

public class UnleashMavenBuildWrapper
extends BuildWrapper {
    private static String ENV_VAR_SCM_USERNAME = "UNLEASH_SCM_USERNAME";
    private static String ENV_VAR_SCM_PASSWORD = "UNLEASH_SCM_PASSWORD";
    private static String ENV_VAR_SCM_SSH_PASSPHRASE = "UNLEASH_SCM_SSH_PASSPHRASE";
    private static String ENV_VAR_SCM_SSH_PRIVATE_KEY = "UNLEASH_SCM_SSH_PRIVATE_KEY";
    private String goals = "unleash:perform";
    private String profiles = "";
    private String releaseArgs = "";
    private List<HookDescriptor> hooks = Lists.newArrayList();
    private boolean useLogTimestamps = true;
    private String tagNamePattern = "@{project.version}";
    private String scmMessagePrefix = "[unleash-maven-plugin]";
    private boolean preselectUseGlobalVersion = false;
    private boolean preselectAllowLocalReleaseArtifacts = true;
    private boolean preselectCommitBeforeTagging = false;
    private String workflowPath = "";
    private String credentialsId;
    private int numberOfBuildsToLock = 1;
    private VersionUpgradeStrategy versionUpgradeStrategy = DescriptorImpl.DEFAULT_VERSION_UPGRADE_STRATEGY;

    @DataBoundConstructor
    public UnleashMavenBuildWrapper(String goals, String profiles, String releaseArgs, boolean useLogTimestamps, String tagNamePattern, String scmMessagePrefix, boolean preselectUseGlobalVersion, List<HookDescriptor> hooks, boolean preselectAllowLocalReleaseArtifacts, boolean preselectCommitBeforeTagging, String workflowPath, String credentialsId, int numberOfBuildsToLock, VersionUpgradeStrategy versionUpgradeStrategy) {
        this.goals = goals;
        this.profiles = profiles;
        this.releaseArgs = releaseArgs;
        this.useLogTimestamps = useLogTimestamps;
        this.tagNamePattern = tagNamePattern;
        this.scmMessagePrefix = scmMessagePrefix;
        this.preselectUseGlobalVersion = preselectUseGlobalVersion;
        this.hooks = hooks;
        this.preselectAllowLocalReleaseArtifacts = preselectAllowLocalReleaseArtifacts;
        this.preselectCommitBeforeTagging = preselectCommitBeforeTagging;
        this.workflowPath = workflowPath;
        this.credentialsId = credentialsId;
        this.numberOfBuildsToLock = numberOfBuildsToLock;
        this.versionUpgradeStrategy = (VersionUpgradeStrategy)MoreObjects.firstNonNull((Object)versionUpgradeStrategy, (Object)VersionUpgradeStrategy.DEFAULT);
    }

    public BuildWrapper.Environment setUp(AbstractBuild build, Launcher launcher, BuildListener listener) {
        if (!this.isReleaseBuild(build)) {
            return new BuildWrapper.Environment(){

                public void buildEnvVars(Map<String, String> env) {
                }
            };
        }
        UnleashArgumentsAction arguments = (UnleashArgumentsAction)build.getAction(UnleashArgumentsAction.class);
        StringBuilder command = new StringBuilder(this.getGoals());
        if (StringUtils.isNotBlank((String)this.workflowPath)) {
            command.append(" -Dworkflow=").append(this.workflowPath);
        }
        if (StringUtils.isNotBlank((String)this.getProfiles())) {
            Iterable split = Splitter.on((char)',').split((CharSequence)this.getProfiles());
            ArrayList profiles = Lists.newArrayList();
            Iterator iterator = split.iterator();
            while (iterator.hasNext()) {
                String profile = (String)iterator.next();
                if (!StringUtils.isNotBlank((String)profile)) continue;
                if (StringUtils.startsWith((String)(profile = profile.trim()), (String)"-")) {
                    profile = StringUtils.replaceOnce((String)profile, (String)"-", (String)"!");
                }
                profiles.add(profile);
            }
            if (!profiles.isEmpty()) {
                String listedProfiles = Joiner.on((char)',').join((Iterable)profiles);
                command.append(" -P ").append(listedProfiles);
                command.append(" -Dunleash.profiles=").append(listedProfiles);
            }
        }
        if (StringUtils.isNotBlank((String)this.getReleaseArgs())) {
            command.append(" -Dunleash.releaseArgs=\"").append(this.getReleaseArgs().trim()).append("\"");
        }
        command.append(" -DenableLogTimestamps=").append(this.isUseLogTimestamps());
        if (this.hooks != null) {
            for (HookDescriptor hookData : this.hooks) {
                if (!StringUtils.isNotBlank((String)hookData.getName()) || !StringUtils.isNotBlank((String)hookData.getData())) continue;
                command.append(" -D").append(hookData.getName()).append("=\"").append(hookData.getData()).append("\"");
                if (!StringUtils.isNotBlank((String)hookData.getRollbackData())) continue;
                command.append(" -D").append(hookData.getName()).append("-rollback=\"").append(hookData.getRollbackData()).append("\"");
            }
        }
        String tagNamePattern = this.getTagNamePattern();
        String scmMessagePrefix = this.getScmMessagePrefix();
        String releaseVersion = null;
        if (arguments != null) {
            tagNamePattern = arguments.getTagNamePattern();
            scmMessagePrefix = arguments.getScmMessagePrefix();
            releaseVersion = arguments.getGlobalReleaseVersion();
            if (arguments.useGlobalReleaseVersion()) {
                command.append(" -Dunleash.releaseVersion=").append(releaseVersion);
                command.append(" -Dunleash.developmentVersion=").append(arguments.getGlobalDevelopmentVersion());
            } else {
                command.append(" -Dunleash.versionUpgradeStrategy=").append(this.getVersionUpgradeStrategy().name());
            }
            command.append(" -Dunleash.allowLocalReleaseArtifacts=").append(arguments.allowLocalReleaseArtifacts());
            command.append(" -Dunleash.commitBeforeTagging=").append(arguments.commitBeforeTagging());
            if (arguments.errorLog()) {
                command.append(" -e");
            }
            if (arguments.debugLog()) {
                command.append(" -X");
            }
        }
        if (StringUtils.isNotBlank((String)tagNamePattern)) {
            command.append(" -Dunleash.tagNamePattern=\"").append(tagNamePattern.trim()).append("\"");
        }
        if (StringUtils.isNotBlank((String)scmMessagePrefix)) {
            command.append(" -Dunleash.scmMessagePrefix=\"").append(scmMessagePrefix.trim()).append("\"");
        }
        Map<String, String> scmEnv = this.updateCommandWithScmCredentials(build, command);
        this.replaceJobParameterReferences(build, command);
        if (releaseVersion == null) {
            MavenModuleSet project = (MavenModuleSet)build.getProject();
            String version = null;
            Optional<Model> model = MavenUtil.parseModel(project.getRootModule(), project);
            if (model.isPresent()) {
                version = (String)MavenUtil.parseVersion((Model)model.get()).orNull();
            }
            if (StringUtils.isBlank(version)) {
                version = project.getRootModule().getVersion();
            }
            releaseVersion = MavenVersionUtil.calculateReleaseVersion(version);
        }
        build.addAction((Action)new UnleashArgumentInterceptorAction(command.toString()));
        build.addAction((Action)new UnleashBadgeAction(releaseVersion));
        return new UnleashEnvironment(scmEnv);
    }

    private Map<String, String> updateCommandWithScmCredentials(AbstractBuild build, StringBuilder command) {
        String scmUsername = null;
        String scmPassword = null;
        String scmSshPassphrase = null;
        String scmSshPrivateKey = null;
        if (StringUtils.isNotBlank((String)this.credentialsId)) {
            StandardUsernameCredentials credentials = (StandardUsernameCredentials)CredentialsProvider.findCredentialById((String)this.credentialsId, StandardUsernameCredentials.class, (Run)build, (List)URIRequirementBuilder.create().build());
            if (credentials instanceof StandardUsernamePasswordCredentials) {
                StandardUsernamePasswordCredentials c = (StandardUsernamePasswordCredentials)credentials;
                scmUsername = c.getUsername();
                scmPassword = c.getPassword().getPlainText();
            } else if (credentials instanceof SSHUserPrivateKey) {
                SSHUserPrivateKey c = (SSHUserPrivateKey)credentials;
                Secret passphrase = c.getPassphrase();
                scmSshPassphrase = passphrase != null ? passphrase.getPlainText() : null;
                List privKeys = c.getPrivateKeys();
                scmSshPrivateKey = privKeys.isEmpty() ? "" : (String)privKeys.get(0);
            }
        }
        HashMap scmEnv = Maps.newHashMap();
        if (scmUsername != null) {
            command.append(" -Dunleash.scmUsernameEnvVar=" + ENV_VAR_SCM_USERNAME);
            scmEnv.put(ENV_VAR_SCM_USERNAME, scmUsername);
        }
        if (scmPassword != null) {
            command.append(" -Dunleash.scmPasswordEnvVar=" + ENV_VAR_SCM_PASSWORD);
            scmEnv.put(ENV_VAR_SCM_PASSWORD, scmPassword);
        }
        if (scmSshPassphrase != null) {
            command.append(" -Dunleash.scmSshPassphraseEnvVar=" + ENV_VAR_SCM_SSH_PASSPHRASE);
            scmEnv.put(ENV_VAR_SCM_SSH_PASSPHRASE, scmSshPassphrase);
        }
        if (scmSshPrivateKey != null) {
            command.append(" -Dunleash.scmSshPrivateKeyEnvVar=" + ENV_VAR_SCM_SSH_PRIVATE_KEY);
            scmEnv.put(ENV_VAR_SCM_SSH_PRIVATE_KEY, scmSshPrivateKey);
        }
        return scmEnv;
    }

    private void replaceJobParameterReferences(AbstractBuild build, StringBuilder command) {
        ParametersAction action;
        if (command != null && (action = (ParametersAction)build.getAction(ParametersAction.class)) != null) {
            int start = command.indexOf("${");
            while (start >= 0) {
                Object value;
                int end = command.indexOf("}", start);
                String name = command.substring(start + 2, end);
                ParameterValue paramValue = action.getParameter(name);
                if (paramValue != null && (value = paramValue.getValue()) != null) {
                    command.replace(start, end + 1, value.toString());
                }
                start = command.indexOf("${", end);
            }
        }
    }

    private boolean isReleaseBuild(AbstractBuild build) {
        return build.getCause(UnleashCause.class) != null;
    }

    public String getGoals() {
        return StringUtils.isBlank((String)this.goals) ? "unleash:perform" : this.goals;
    }

    public void setGoals(String goals) {
        this.goals = goals;
    }

    public String getProfiles() {
        return this.profiles;
    }

    public void setProfiles(String profiles) {
        this.profiles = profiles;
    }

    public String getReleaseArgs() {
        return this.releaseArgs;
    }

    public void setReleaseArgs(String releaseArgs) {
        this.releaseArgs = releaseArgs;
    }

    public boolean isUseLogTimestamps() {
        return this.useLogTimestamps;
    }

    public void setUseLogTimestamps(boolean useLogTimestamps) {
        this.useLogTimestamps = useLogTimestamps;
    }

    public String getTagNamePattern() {
        return StringUtils.isBlank((String)this.tagNamePattern) ? "@{project.version}" : this.tagNamePattern;
    }

    public void setTagNamePattern(String tagNamePattern) {
        this.tagNamePattern = tagNamePattern;
    }

    public String getScmMessagePrefix() {
        return this.scmMessagePrefix;
    }

    public void setScmMessagePrefix(String scmMessagePrefix) {
        this.scmMessagePrefix = scmMessagePrefix;
    }

    public boolean isPreselectUseGlobalVersion() {
        return this.preselectUseGlobalVersion;
    }

    public void setPreselectUseGlobalVersion(boolean preselectUseGlobalVersion) {
        this.preselectUseGlobalVersion = preselectUseGlobalVersion;
    }

    public Collection<? extends Action> getProjectActions(AbstractProject job) {
        return Collections.singleton(new UnleashAction((MavenModuleSet)job, this.preselectUseGlobalVersion, this.preselectAllowLocalReleaseArtifacts, this.preselectCommitBeforeTagging, false, false, this.versionUpgradeStrategy, this.getTagNamePattern(), this.getScmMessagePrefix()));
    }

    public List<HookDescriptor> getHooks() {
        return this.hooks;
    }

    public void setHooks(List<HookDescriptor> hooks) {
        this.hooks = hooks;
    }

    public boolean isPreselectAllowLocalReleaseArtifacts() {
        return this.preselectAllowLocalReleaseArtifacts;
    }

    public void setPreselectAllowLocalReleaseArtifacts(boolean preselectAllowLocalReleaseArtifacts) {
        this.preselectAllowLocalReleaseArtifacts = preselectAllowLocalReleaseArtifacts;
    }

    public boolean isPreselectCommitBeforeTagging() {
        return this.preselectCommitBeforeTagging;
    }

    public void setPreselectCommitBeforeTagging(boolean preselectCommitBeforeTagging) {
        this.preselectCommitBeforeTagging = preselectCommitBeforeTagging;
    }

    public String getWorkflowPath() {
        return this.workflowPath;
    }

    public void setWorkflowPath(String workflowPath) {
        this.workflowPath = workflowPath;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public void setCredentialsId(String credentialsId) {
        this.credentialsId = credentialsId;
    }

    public int getNumberOfBuildsToLock() {
        return this.numberOfBuildsToLock;
    }

    public void setNumberOfBuildsToLock(int numberOfBuildsToLock) {
        this.numberOfBuildsToLock = numberOfBuildsToLock;
    }

    public VersionUpgradeStrategy getVersionUpgradeStrategy() {
        return this.versionUpgradeStrategy != null ? this.versionUpgradeStrategy : VersionUpgradeStrategy.DEFAULT;
    }

    public void setVersionUpgradeStrategy(VersionUpgradeStrategy versionUpgradeStrategy) {
        this.versionUpgradeStrategy = (VersionUpgradeStrategy)MoreObjects.firstNonNull((Object)versionUpgradeStrategy, (Object)VersionUpgradeStrategy.DEFAULT);
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public static final String DEFAULT_GOALS = "unleash:perform";
        public static final String DEFAULT_PROFILES = "";
        public static final String DEFAULT_RELEASE_ARGS = "";
        public static final boolean DEFAULT_USE_LOG_TIMESTAMPS = true;
        public static final String DEFAULT_TAG_NAME_PATTERN = "@{project.version}";
        public static final String DEFAULT_SCM_MESSAGE_PREFIX = "[unleash-maven-plugin]";
        public static final boolean DEFAULT_PRESELECT_USE_GLOBAL_VERSION = false;
        public static final boolean DEFAULT_PRESELECT_ALLOW_LOCAL_RELEASE_ARTIFACTS = true;
        public static final boolean DEFAULT_PRESELECT_COMMIT_BEFORE_TAGGING = false;
        public static final String DEFAULT_WORKFLOW_PATH = "";
        public static final int DEFAULT_NUMBER_OF_LOCKED_BUILDS = 1;
        public static final VersionUpgradeStrategy DEFAULT_VERSION_UPGRADE_STRATEGY = VersionUpgradeStrategy.DEFAULT;
        private static final CredentialsMatcher CREDENTIALS_MATCHER = CredentialsMatchers.anyOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.instanceOf(StandardUsernamePasswordCredentials.class), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class)});
        private boolean useLogTimestamps = true;
        private boolean preselectAllowLocalReleaseArtifacts = true;
        private boolean preselectCommitBeforeTagging = false;
        private String tagNamePattern = "@{project.version}";
        private String scmMessagePrefix = "[unleash-maven-plugin]";

        public void setUseLogTimestamps(boolean useLogTimestamps) {
            this.useLogTimestamps = useLogTimestamps;
        }

        public boolean isUseLogTimestamps() {
            return this.useLogTimestamps;
        }

        public void setPreselectAllowLocalReleaseArtifacts(boolean preselectAllowLocalReleaseArtifacts) {
            this.preselectAllowLocalReleaseArtifacts = preselectAllowLocalReleaseArtifacts;
        }

        public boolean isPreselectAllowLocalReleaseArtifacts() {
            return this.preselectAllowLocalReleaseArtifacts;
        }

        public void setPreselectCommitBeforeTagging(boolean preselectCommitBeforeTagging) {
            this.preselectCommitBeforeTagging = preselectCommitBeforeTagging;
        }

        public boolean isPreselectCommitBeforeTagging() {
            return this.preselectCommitBeforeTagging;
        }

        public void setTagNamePattern(String tagNamePattern) {
            this.tagNamePattern = tagNamePattern;
        }

        public String getTagNamePattern() {
            return this.tagNamePattern;
        }

        public void setScmMessagePrefix(String scmMessagePrefix) {
            this.scmMessagePrefix = scmMessagePrefix;
        }

        public String getScmMessagePrefix() {
            return this.scmMessagePrefix;
        }

        public boolean isApplicable(AbstractProject<?, ?> item) {
            return item instanceof AbstractMavenProject;
        }

        @NonNull
        public String getDisplayName() {
            return "Unleash";
        }

        public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
            req.bindJSON((Object)this, json);
            this.save();
            return super.configure(req, json);
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String credentialsId) {
            Authentication authentication;
            if (context == null || !context.hasPermission(Item.CONFIGURE)) {
                return new ListBoxModel();
            }
            AbstractIdCredentialsListBoxModel abstractIdCredentialsListBoxModel = new StandardListBoxModel().includeEmptyValue();
            if (context instanceof Queue.Task) {
                Queue.Task task = (Queue.Task)context;
                authentication = Tasks.getAuthenticationOf2((Queue.Task)task);
            } else {
                authentication = ACL.SYSTEM2;
            }
            return abstractIdCredentialsListBoxModel.includeMatchingAs(authentication, context, StandardUsernameCredentials.class, URIRequirementBuilder.create().build(), CREDENTIALS_MATCHER);
        }

        @POST
        public ListBoxModel doFillVersionUpgradeStrategyItems() {
            ListBoxModel items = new ListBoxModel();
            for (VersionUpgradeStrategy strategy : VersionUpgradeStrategy.values()) {
                items.add(strategy.name(), strategy.name());
            }
            return items;
        }
    }

    private class UnleashEnvironment
    extends BuildWrapper.Environment {
        private Map<String, String> scmEnv;

        public UnleashEnvironment(Map<String, String> scmEnv) {
            super((BuildWrapper)UnleashMavenBuildWrapper.this);
            this.scmEnv = scmEnv;
        }

        public void buildEnvVars(Map<String, String> env) {
            env.putAll(this.scmEnv);
        }

        public boolean tearDown(AbstractBuild build, BuildListener listener) throws IOException, InterruptedException {
            int lockedBuilds = 0;
            Result result = build.getResult();
            if (result != null && result.isBetterOrEqualTo(Result.UNSTABLE)) {
                if (UnleashMavenBuildWrapper.this.numberOfBuildsToLock != 0) {
                    build.keepLog();
                    ++lockedBuilds;
                }
                for (Run run : build.getProject().getBuilds()) {
                    if (!this.isSuccessfulReleaseBuild(run)) continue;
                    if (UnleashMavenBuildWrapper.this.numberOfBuildsToLock < 0 || lockedBuilds < UnleashMavenBuildWrapper.this.numberOfBuildsToLock) {
                        run.keepLog();
                        ++lockedBuilds;
                        continue;
                    }
                    run.keepLog(false);
                }
            }
            return super.tearDown(build, listener);
        }

        private boolean isSuccessfulReleaseBuild(Run run) {
            UnleashBadgeAction badgeAction = (UnleashBadgeAction)run.getAction(UnleashBadgeAction.class);
            if (badgeAction != null && !run.isBuilding()) {
                Result result = run.getResult();
                return result != null && result.isBetterOrEqualTo(Result.UNSTABLE);
            }
            return false;
        }
    }
}

