/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.jenkins.plugins.unleash;

import com.google.common.base.Strings;
import com.itemis.jenkins.plugins.unleash.UnleashArgumentsAction;
import hudson.model.BuildBadgeAction;
import hudson.model.Result;
import hudson.model.Run;
import jenkins.model.RunAction2;

public class UnleashBadgeAction
implements BuildBadgeAction,
RunAction2 {
    private Run<?, ?> run;
    private String version;

    public UnleashBadgeAction(String version) {
        this.version = version;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return null;
    }

    public void onAttached(Run<?, ?> run) {
        this.run = run;
    }

    public void onLoad(Run<?, ?> run) {
        this.run = run;
    }

    public String getTooltipText() {
        StringBuilder sb = new StringBuilder();
        if (this.isFailedBuild()) {
            sb.append("Failed release");
        } else {
            sb.append("Release");
        }
        sb.append(" - ").append(this.getVersion());
        return sb.toString();
    }

    public boolean isSuccessfulBuild() {
        Result result;
        if (this.run != null && (result = this.run.getResult()) != null) {
            return result.isBetterOrEqualTo(Result.SUCCESS);
        }
        return false;
    }

    public boolean isFailedBuild() {
        Result result;
        if (this.run != null && (result = this.run.getResult()) != null) {
            return result.isWorseOrEqualTo(Result.FAILURE);
        }
        return false;
    }

    public boolean isUnstableBuild() {
        Result result;
        if (this.run != null && (result = this.run.getResult()) != null) {
            return result.isBetterOrEqualTo(Result.UNSTABLE) && result.isWorseOrEqualTo(Result.UNSTABLE);
        }
        return false;
    }

    public boolean isBuilding() {
        return this.run.isBuilding();
    }

    public String getVersion() {
        if (!Strings.isNullOrEmpty((String)this.version)) {
            return this.version;
        }
        UnleashArgumentsAction args = (UnleashArgumentsAction)this.run.getAction(UnleashArgumentsAction.class);
        if (args != null) {
            return args.getGlobalReleaseVersion();
        }
        return "Unknown Version";
    }

    public void setVersion(String version) {
        if (!Strings.isNullOrEmpty((String)version)) {
            this.version = version;
        }
    }
}

