/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.thememanager;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.PageDecorator;
import hudson.model.RootAction;
import hudson.model.User;
import hudson.util.HttpResponses;
import io.jenkins.plugins.thememanager.Theme;
import io.jenkins.plugins.thememanager.ThemeManagerFactory;
import io.jenkins.plugins.thememanager.ThemeManagerFactoryDescriptor;
import io.jenkins.plugins.thememanager.ThemeUserProperty;
import io.jenkins.plugins.thememanager.none.NoOpThemeManagerFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import jenkins.appearance.AppearanceCategory;
import jenkins.model.GlobalConfigurationCategory;
import net.sf.json.JSONObject;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.Ancestor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

@Extension
@Symbol(value={"themeManager"})
public class ThemeManagerPageDecorator
extends PageDecorator {
    private ThemeManagerFactory theme;
    private boolean disableUserThemes;

    public ThemeManagerPageDecorator() {
        this.load();
    }

    public static ThemeManagerPageDecorator get() {
        return (ThemeManagerPageDecorator)((Object)ExtensionList.lookupSingleton(ThemeManagerPageDecorator.class));
    }

    public boolean configure(StaplerRequest2 req, JSONObject formData) {
        req.bindJSON((Object)this, formData);
        this.save();
        return true;
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(AppearanceCategory.class);
    }

    @DataBoundSetter
    public void setTheme(ThemeManagerFactory theme) {
        this.theme = theme;
    }

    public ThemeManagerFactory getTheme() {
        if (this.theme == null) {
            return new NoOpThemeManagerFactory();
        }
        return this.theme;
    }

    public boolean isDisableUserThemes() {
        return this.disableUserThemes;
    }

    @DataBoundSetter
    public void setDisableUserThemes(boolean disableUserThemes) {
        this.disableUserThemes = disableUserThemes;
    }

    @NonNull
    public Theme findTheme() {
        Theme userTheme;
        if (!this.disableUserThemes && (userTheme = ThemeUserProperty.forCurrentUser()) != null) {
            return userTheme;
        }
        if (this.theme != null) {
            return this.theme.getTheme();
        }
        return new NoOpThemeManagerFactory().getTheme();
    }

    @NonNull
    public ThemeManagerFactory findThemeFactory() {
        ThemeManagerFactory userTheme;
        if (!this.disableUserThemes && (userTheme = ThemeUserProperty.forCurrentUserFactory()) != null) {
            return userTheme;
        }
        if (this.theme != null) {
            return this.theme;
        }
        return new NoOpThemeManagerFactory();
    }

    @NonNull
    public boolean shouldShowAccountThemePicker() {
        return User.current() != null && !this.isDisableUserThemes();
    }

    public String getHeaderHtml() {
        boolean injectCss = this.shouldInjectCss();
        Set namespacedThemes = ThemeManagerFactoryDescriptor.all().stream().filter(ThemeManagerFactoryDescriptor::isNamespaced).map(desc -> desc.getInstance().getTheme().generateHeaderElements(injectCss)).flatMap(Collection::stream).collect(Collectors.toSet());
        ThemeManagerFactory themeManagerFactory = this.findThemeFactory();
        namespacedThemes.add(themeManagerFactory.getTheme().generateProperties());
        if (!themeManagerFactory.getDescriptor().isNamespaced()) {
            LinkedHashSet<String> data = new LinkedHashSet<String>(themeManagerFactory.getTheme().generateHeaderElements(injectCss));
            data.addAll(namespacedThemes);
            return String.join((CharSequence)"\n", data);
        }
        return String.join((CharSequence)"\n", namespacedThemes);
    }

    public String getThemeKey() {
        ThemeManagerFactory themeFactory = this.findThemeFactory();
        return themeFactory.getDescriptor().getThemeKey();
    }

    public boolean isRespectSystemAppearance() {
        ThemeManagerFactory themeFactory = this.findThemeFactory();
        return themeFactory.getTheme().isRespectSystemAppearance();
    }

    public boolean shouldInjectCss() {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        if (req == null) {
            return false;
        }
        List ancestors = req.getAncestors();
        if (ancestors == null || ancestors.size() == 0) {
            return false;
        }
        Ancestor a = (Ancestor)ancestors.get(ancestors.size() - 1);
        Object o = a.getObject();
        return !o.getClass().getName().startsWith("com.smartcodeltd.jenkinsci.plugins.buildmonitor");
    }

    @Extension
    public static class ThemeAction
    implements RootAction {
        public String getUrlName() {
            return "theme";
        }

        public String getDisplayName() {
            return null;
        }

        public String getIconFileName() {
            return null;
        }

        @RequirePOST
        public HttpResponse doSet(@QueryParameter String value) throws IOException {
            if (ThemeManagerPageDecorator.get().isDisableUserThemes()) {
                throw new RuntimeException("Setting user themes is disabled");
            }
            User user = User.current();
            if (user == null) {
                throw new RuntimeException("User is not signed in");
            }
            ThemeUserProperty p = (ThemeUserProperty)user.getProperty(ThemeUserProperty.class);
            p.setTheme(ThemeManagerFactoryDescriptor.all().stream().filter(e -> e.getThemeKey().equals(value)).findFirst().orElseThrow().getInstance());
            user.save();
            return HttpResponses.ok();
        }
    }
}

