/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.tacotruck;

import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.util.ArgumentListBuilder;
import io.jenkins.plugins.tacotruck.CLIResult;
import io.jenkins.plugins.tacotruck.CredentialsHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class TacotruckCLIHelper {
    private static final Logger LOGGER = Logger.getLogger(TacotruckCLIHelper.class.getName());

    protected static CLIResult executeCLI(String[] command, Launcher launcher, TaskListener listener, FilePath workspace) throws IOException, InterruptedException {
        return TacotruckCLIHelper.executeCLI(command, launcher, listener, workspace, null);
    }

    protected static CLIResult executeCLI(String[] command, Launcher launcher, TaskListener listener, FilePath workspace, EnvVars envVars) throws IOException, InterruptedException {
        try {
            ArgumentListBuilder args = new ArgumentListBuilder();
            for (String arg : command) {
                args.add(arg);
            }
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            Launcher.ProcStarter ps = launcher.launch().pwd(workspace).cmds(args).stdout((OutputStream)outputStream);
            if (envVars != null) {
                ps = ps.envs((Map)envVars);
            }
            int exitCode = ps.join();
            String output = outputStream.toString(StandardCharsets.UTF_8).trim();
            return new CLIResult(exitCode, output, exitCode == 0, null);
        }
        catch (InterruptedException e) {
            String errorMsg = "\u2717 Failed to execute CLI command: " + e.getMessage();
            listener.getLogger().println(errorMsg);
            throw e;
        }
        catch (IOException e) {
            String errorMsg = "\u2717 Failed to execute CLI command: " + e.getMessage();
            listener.getLogger().println(errorMsg);
            throw e;
        }
    }

    protected static boolean isTacotruckCliAvailable(Launcher launcher, TaskListener listener, FilePath workspace, EnvVars envVars) throws IOException, InterruptedException {
        try {
            CLIResult result = TacotruckCLIHelper.executeCLI(new String[]{"npx", "@testfiesta/tacotruck", "--version"}, launcher, listener, workspace, envVars);
            if (result.isSuccess()) {
                LOGGER.fine("\u2713 TacoTruck CLI is available via npx: " + result.getOutput());
                listener.getLogger().println("\u2713 TacoTruck CLI is available via npx: " + result.getOutput());
                return true;
            }
            if (result.getErrorMessage() != null) {
                LOGGER.fine("\u2717 TacoTruck CLI not found via npx: " + result.getErrorMessage());
                listener.getLogger().println("\u2717 TacoTruck CLI not found via npx: " + result.getErrorMessage());
                listener.getLogger().println("Please ensure Node.js and npm are available in PATH");
            } else {
                LOGGER.fine("\u2717 TacoTruck CLI check failed with exit code: " + result.getExitCode());
                listener.getLogger().println("\u2717 TacoTruck CLI check failed with exit code: " + result.getExitCode());
            }
            return false;
        }
        catch (IOException e) {
            Thread.currentThread().interrupt();
            LOGGER.fine("TacoTruck CLI availability check was interrupted");
            listener.getLogger().println("\u2717 TacoTruck CLI availability check was interrupted");
            throw e;
        }
    }

    protected static boolean isTacotruckCliAvailable(Launcher launcher, TaskListener listener, FilePath workspace) throws IOException, InterruptedException {
        return TacotruckCLIHelper.isTacotruckCliAvailable(launcher, listener, workspace, null);
    }

    protected static String findNpxPath(Launcher launcher, TaskListener listener, FilePath workspace, EnvVars envVars) throws IOException, InterruptedException {
        CLIResult result = TacotruckCLIHelper.executeCLI(new String[]{"which", "npx"}, launcher, listener, workspace, envVars);
        return result.isSuccess() ? result.getOutput() : null;
    }

    protected static String getTacotruckCliVersion(Launcher launcher, TaskListener listener, FilePath workspace, EnvVars envVars) throws IOException, InterruptedException {
        String npxPath = TacotruckCLIHelper.findNpxPath(launcher, listener, workspace, envVars);
        CLIResult result = TacotruckCLIHelper.executeCLI(new String[]{npxPath, "@testfiesta/tacotruck", "--version"}, launcher, listener, workspace, envVars);
        return result.isSuccess() ? result.getOutput() : null;
    }

    protected static String getTacotruckCliVersion(Launcher launcher, TaskListener listener, FilePath workspace) throws IOException, InterruptedException {
        return TacotruckCLIHelper.getTacotruckCliVersion(launcher, listener, workspace, null);
    }

    protected static String[] buildSubmitCommand(String provider, String resultsPath, String project, String apiToken, String handle, String runName, String baseUrl, String npxPath) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(npxPath);
        cmd.add("@testfiesta/tacotruck");
        cmd.add(provider);
        cmd.add("run:submit");
        cmd.add("--token");
        cmd.add(apiToken);
        cmd.add("--data");
        cmd.add(resultsPath);
        cmd.add("--organization");
        cmd.add(handle);
        cmd.add("--name");
        cmd.add(runName);
        cmd.add("--project");
        cmd.add(project);
        cmd.add("--url");
        cmd.add(baseUrl);
        return cmd.toArray(new String[0]);
    }

    protected static CLIResult submitResults(String provider, String resultsPath, String project, String apiToken, String handle, String runName, String baseUrl, Launcher launcher, TaskListener listener, FilePath workspace, EnvVars envVars) throws IOException, InterruptedException {
        listener.getLogger().println("Submitting test results to TacoTruck...");
        String npxPath = TacotruckCLIHelper.findNpxPath(launcher, listener, workspace, envVars);
        String[] command = TacotruckCLIHelper.buildSubmitCommand(provider, resultsPath, project, apiToken, handle, runName, baseUrl, npxPath);
        StringBuilder logCmd = new StringBuilder();
        for (int i = 0; i < command.length; ++i) {
            if (i > 0) {
                logCmd.append(" ");
            }
            if ("--token".equals(command[i]) && i + 1 < command.length) {
                logCmd.append("--token ***");
                ++i;
                continue;
            }
            logCmd.append(command[i]);
        }
        listener.getLogger().println("Executing: " + logCmd.toString());
        CLIResult result = TacotruckCLIHelper.executeCLI(command, launcher, listener, workspace, envVars);
        listener.getLogger().println(result.getOutput());
        return result;
    }

    protected static String getApiToken(String credentialsId) {
        if (credentialsId == null || credentialsId.isBlank()) {
            return null;
        }
        StringCredentials credentials = CredentialsHelper.lookupApiTokenCredentials(credentialsId);
        if (credentials != null) {
            return credentials.getSecret().getPlainText();
        }
        return null;
    }

    protected static CLIResult submitResultsWithCredentials(String provider, String resultsPath, String project, String credentialsId, String handle, String runName, String baseUrl, Launcher launcher, TaskListener listener, FilePath workspace, EnvVars envVars) throws IOException, InterruptedException {
        String apiToken = TacotruckCLIHelper.getApiToken(credentialsId);
        if (apiToken == null) {
            String errorMsg = "\u2717 Failed to retrieve API token from credentials: " + credentialsId;
            listener.getLogger().println(errorMsg);
            throw new AbortException(errorMsg);
        }
        return TacotruckCLIHelper.submitResults(provider, resultsPath, project, apiToken, handle, runName, baseUrl, launcher, listener, workspace, envVars);
    }
}

