/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

final class LocalRunExecutor {
    private static final String API_KEY_ENV = "SEDSTART_API_KEY";

    LocalRunExecutor() {
    }

    void execute(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener, Integer projectId, Integer suiteId, Integer testId, Integer profileId, String browser, boolean headless, String environment) throws IOException, InterruptedException {
        LocalRunExecutor.validate(projectId, suiteId, testId, profileId);
        String apiKey = (String)env.get((Object)API_KEY_ENV);
        if (apiKey == null || apiKey.isEmpty()) {
            throw new IOException("SEDSTART_API_KEY is not set. Use Jenkins credentials binding.");
        }
        env.put(API_KEY_ENV, apiKey);
        env.put("SEDSTART_PROJECT_ID", projectId.toString());
        env.put("SEDSTART_PROFILE_ID", profileId.toString());
        env.put("SEDSTART_BROWSER", browser == null ? "chrome" : browser);
        env.put("SEDSTART_HEADLESS", Boolean.toString(headless));
        env.put("SEDSTART_ENV", environment == null ? "PROD" : environment);
        boolean isUnix = launcher.isUnix();
        List<String> installCmd = isUnix ? List.of("bash", "-c", "    set -euo pipefail\n\n    OS=\"$(uname -s | tr '[:upper:]' '[:lower:]')\"\n    ARCH=\"$(uname -m)\"\n\n    case \"$OS\" in\n      linux) PLATFORM_OS=linux ;;\n      darwin) PLATFORM_OS=darwin ;;\n      *) echo \"Unsupported OS: $OS\"; exit 1 ;;\n    esac\n\n    case \"$ARCH\" in\n      x86_64|amd64) PLATFORM_ARCH=amd64 ;;\n      arm64|aarch64) PLATFORM_ARCH=arm64 ;;\n      i386|i686) PLATFORM_ARCH=386 ;;\n      *) echo \"Unsupported ARCH: $ARCH\"; exit 1 ;;\n    esac\n\n    case \"$PLATFORM_OS/$PLATFORM_ARCH\" in\n      linux/amd64|darwin/amd64) VARIANT=v1 ;;\n      linux/arm64|darwin/arm64) VARIANT=v8.0 ;;\n      linux/386) VARIANT=sse2 ;;\n      *) echo \"No variant for $PLATFORM_OS/$PLATFORM_ARCH\"; exit 1 ;;\n    esac\n\n    SEDSTART_HOME=\"$HOME/.sedstart\"\n    BIN=\"$SEDSTART_HOME/sedstart\"\n\n    mkdir -p \"$SEDSTART_HOME\"\n\n    if [ \"$SEDSTART_ENV\" = \"QA\" ]; then\n      BASE_URL=\"https://cli.sedinqa.com/latest\"\n      API_URL=\"https://sedstart.sedinqa.com/api\"\n    else\n      BASE_URL=\"https://cli.sedstart.com/latest\"\n      API_URL=\"https://app.sedstart.com/api\"\n    fi\n\n    URL=\"$BASE_URL/cli_${PLATFORM_OS}_${PLATFORM_ARCH}_${VARIANT}/sedstart\"\n\n    if [ ! -f \"$BIN\" ]; then\n      echo \"sedstart not found, downloading\"\n      curl -fL \"$URL\" -o \"$BIN\"\n      chmod +x \"$BIN\"\n    else\n      echo \"sedstart already exists, skipping download\"\n    fi\n\n    {\n      echo \"url=$API_URL\"\n      echo \"key=$SEDSTART_API_KEY\"\n    } > \"$SEDSTART_HOME/default.env\"\n") : List.of("powershell", "-NoProfile", "-NonInteractive", "-Command", "    $ErrorActionPreference = \"Stop\"\n\n    $home = $Env:USERPROFILE\n    $sedstartHome = \"$home\\.sedstart\"\n    $bin = \"$sedstartHome\\sedstart.exe\"\n\n    New-Item -ItemType Directory -Force $sedstartHome | Out-Null\n\n    $os = \"windows\"\n    if ($Env:PROCESSOR_ARCHITECTURE -match \"ARM64\") { $arch = \"arm64\" }\n    elseif ($Env:PROCESSOR_ARCHITECTURE -match \"AMD64\") { $arch = \"amd64\" }\n    else { $arch = \"386\" }\n\n    switch (\"$os/$arch\") {\n      \"windows/amd64\" { $variant = \"v1\" }\n      \"windows/arm64\" { $variant = \"v8.0\" }\n      \"windows/386\"   { $variant = \"sse2\" }\n      default { throw \"Unsupported $os/$arch\" }\n    }\n\n    if ($Env:SEDSTART_ENV -eq \"QA\") {\n      $base = \"https://cli.sedinqa.com/latest\"\n      $api  = \"https://sedstart.sedinqa.com/api\"\n    } else {\n      $base = \"https://cli.sedstart.com/latest\"\n      $api  = \"https://app.sedstart.com/api\"\n    }\n\n    $url = \"$base/cli_${os}_${arch}_${variant}/sedstart.exe\"\n\n    if (!(Test-Path $bin)) {\n      Invoke-WebRequest -Uri $url -OutFile $bin\n    }\n\n    @(\n      \"url=$api\",\n      \"key=$Env:SEDSTART_API_KEY\"\n    ) | Set-Content \"$sedstartHome\\default.env\"\n");
        Launcher.ProcStarter installPs = launcher.launch();
        installPs.cmds(installCmd);
        installPs.envs((Map)env);
        installPs.pwd(workspace);
        installPs.stdout((OutputStream)listener.getLogger());
        installPs.stderr((OutputStream)listener.getLogger());
        if (installPs.join() != 0) {
            throw new IOException("sedstart installation failed");
        }
        Launcher.ProcStarter runPs = launcher.launch();
        if (isUnix) {
            String cmd = "SEDSTART_HOME=\"$HOME/.sedstart\"; cd \"$SEDSTART_HOME\" && BROWSER=\"" + (String)env.get((Object)"SEDSTART_BROWSER") + "\"; if [ \"$(uname -s | tr A-Z a-z)\" = \"linux\" ] && [ \"$BROWSER\" = \"chrome\" ]; then   BROWSER=\"chromium\"; fi; CMD=\"./sedstart run -b $BROWSER -p " + projectId + " -d " + profileId + " " + (testId != null ? "-t " + testId : "-s " + suiteId) + " " + (headless ? "-q " : "") + "-e default.env\"; if [ \"" + headless + "\" = \"true\" ]; then   echo 'Running HEADLESS';   eval \"$CMD\"; else   echo 'Running HEADED';   if [ \"$(uname -s | tr A-Z a-z)\" = \"linux\" ]; then     if [ -z \"${DISPLAY:-}\" ]; then       eval \"$CMD\";     else       if command -v xvfb-run >/dev/null 2>&1; then         xvfb-run -a eval \"$CMD\";       else         echo 'ERROR: DISPLAY set but xvfb not available'; exit 1;       fi;     fi;   else     eval \"$CMD\";   fi; fi";
            runPs.cmds(new String[]{"bash", "-c", cmd});
        } else {
            String cmd = "$env:SEDSTART_HOME=\"$Env:USERPROFILE\\.sedstart\"; cd $env:SEDSTART_HOME; .\\sedstart.exe run -b " + (String)env.get((Object)"SEDSTART_BROWSER") + " -p " + projectId + " -d " + profileId + " " + (testId != null ? "-t " + testId : "-s " + suiteId) + " " + (headless ? "-q " : "") + "-e default.env";
            runPs.cmds(new String[]{"powershell", "-NoProfile", "-NonInteractive", "-Command", cmd});
        }
        runPs.envs((Map)env);
        runPs.pwd(workspace);
        runPs.stdout((OutputStream)listener.getLogger());
        runPs.stderr((OutputStream)listener.getLogger());
        if (runPs.join() != 0) {
            throw new IOException("sedstart CLI failed");
        }
    }

    private static void validate(Integer projectId, Integer suiteId, Integer testId, Integer profileId) throws IOException {
        if (projectId == null) {
            throw new IOException("projectId is required");
        }
        if (profileId == null) {
            throw new IOException("profileId is required");
        }
        if (suiteId == null && testId == null || suiteId != null && testId != null) {
            throw new IOException("Provide exactly one of suiteId or testId");
        }
    }
}

