/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.genericdiff;

import hudson.FilePath;
import hudson.model.AbstractBuild;
import io.jenkins.plugins.report.genericdiff.CommandCallable;
import io.jenkins.plugins.report.genericdiff.Constants;
import io.jenkins.plugins.report.genericdiff.OperationFailedException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class RpmsReportPublisherImpl {
    private final String command;
    private final String id;

    public RpmsReportPublisherImpl(String command, String id) {
        this.command = command;
        this.id = id;
    }

    public Result perform(AbstractBuild<?, ?> build) throws InterruptedException, IOException {
        if (build == null) {
            throw new IOException("No build found");
        }
        Result r = new Result();
        try {
            File prevRpmsFile;
            FilePath ws = build.getWorkspace();
            if (ws == null) {
                throw new IOException("No workspace found");
            }
            List rpms = (List)ws.act((FilePath.FileCallable)new CommandCallable(this.command));
            Files.write(new File(build.getRootDir(), Constants.getALL(this.id)).toPath(), (Iterable<? extends CharSequence>)rpms, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            r.total = rpms.size();
            AbstractBuild previousBuild = build.getPreviousBuild();
            if (previousBuild != null && (prevRpmsFile = new File(previousBuild.getRootDir(), Constants.getALL(this.id))).exists() && prevRpmsFile.isFile() && prevRpmsFile.canRead()) {
                HashSet<String> prevRpms = new HashSet<String>(Files.readAllLines(prevRpmsFile.toPath()));
                Iterator rpmsIterator = rpms.iterator();
                while (rpmsIterator.hasNext()) {
                    String rpm = (String)rpmsIterator.next();
                    if (!prevRpms.remove(rpm)) continue;
                    rpmsIterator.remove();
                }
                List removedRpms = prevRpms.stream().sorted().collect(Collectors.toList());
                Files.write(new File(build.getRootDir(), Constants.getNEW(this.id)).toPath(), (Iterable<? extends CharSequence>)rpms, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                r.changes += rpms.size();
                Files.write(new File(build.getRootDir(), Constants.getREMOVED(this.id)).toPath(), removedRpms, StandardCharsets.UTF_8, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                r.changes += removedRpms.size();
            }
        }
        catch (OperationFailedException ex) {
            Files.write(new File(build.getRootDir(), Constants.getCOMMAND_STDERR(this.id)).toPath(), Arrays.asList(ex.getMessage()), StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            r.broken = true;
        }
        return r;
    }

    public static class Result {
        int total = 0;
        int changes = 0;
        boolean broken = false;

        public boolean isEmpty() {
            return this.total == 0;
        }

        public boolean isChanged() {
            return this.changes != 0;
        }

        public boolean isBroken() {
            return this.broken;
        }
    }
}

