/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.genericdiff;

import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.Result;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import hudson.util.FormValidation;
import io.jenkins.plugins.report.genericdiff.DiffReportAction;
import io.jenkins.plugins.report.genericdiff.RpmsReportAction;
import io.jenkins.plugins.report.genericdiff.RpmsReportOneRecord;
import io.jenkins.plugins.report.genericdiff.RpmsReportPublisherImpl;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class RpmsReportPublisher
extends Recorder {
    private boolean moveunstable;
    private boolean movefailed;
    private boolean moveempty;
    private List<RpmsReportOneRecord> configurations;
    private int buildstopast;
    private static final Logger LOGGER = Logger.getLogger(RpmsReportPublisher.class.getName());
    @Extension
    public static final DescriptorImpl DESCRIPTOR = new DescriptorImpl();

    @DataBoundConstructor
    public RpmsReportPublisher(int buildstopast, boolean moveunstable, boolean movefailed, boolean moveempty, List<RpmsReportOneRecord> configurations) {
        this.configurations = configurations;
        this.buildstopast = buildstopast;
        this.moveunstable = moveunstable;
        this.movefailed = movefailed;
        this.moveempty = moveempty;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        boolean result = true;
        ArrayList<CallSite> changeditems = new ArrayList<CallSite>();
        ArrayList<CallSite> failedItems = new ArrayList<CallSite>();
        ArrayList<CallSite> emptyItems = new ArrayList<CallSite>();
        for (RpmsReportOneRecord configuration : this.getConfigurations()) {
            RpmsReportPublisherImpl.Result run = new RpmsReportPublisherImpl(configuration.getCommand(), configuration.getId()).perform(build);
            if (run.isChanged()) {
                changeditems.add((CallSite)((Object)(configuration.getId() + "(" + configuration.getCommand() + ")")));
            }
            if (run.isBroken()) {
                failedItems.add((CallSite)((Object)(configuration.getId() + "(" + configuration.getCommand() + ")")));
                continue;
            }
            if (!run.isEmpty()) continue;
            emptyItems.add((CallSite)((Object)(configuration.getId() + "(" + configuration.getCommand() + ")")));
        }
        DiffReportAction diff = new DiffReportAction(build);
        build.addAction((Action)diff);
        RpmsReportAction action = new RpmsReportAction(build);
        build.addAction((Action)action);
        FormValidation fv = this.doCheckConfigurations(this.configurations);
        listener.getLogger().println("[diff plugin] ID validation " + String.valueOf(fv.kind) + " " + fv.getMessage());
        listener.getLogger().println("[diff plugin] found changes in: " + String.valueOf(changeditems));
        listener.getLogger().println("[diff plugin] possible error in: " + String.valueOf(failedItems));
        listener.getLogger().println("[diff plugin] empty readings: " + String.valueOf(emptyItems));
        if (this.isMoveunstable() && changeditems.size() > 0) {
            build.setResult(Result.UNSTABLE);
        }
        if (this.isMovefailed() && failedItems.size() > 0) {
            build.setResult(Result.FAILURE);
        }
        if (this.isMoveempty() && emptyItems.size() > 0) {
            build.setResult(Result.FAILURE);
        }
        return result;
    }

    public void validateId() {
        FormValidation r = this.doCheckConfigurations(this.configurations);
        if (r.kind != FormValidation.Kind.OK) {
            LOGGER.log(Level.SEVERE, r.getMessage());
        }
    }

    @RequirePOST
    public FormValidation doCheckConfigurations(@QueryParameter List<RpmsReportOneRecord> configurations) {
        if (!Jenkins.get().hasPermission(Jenkins.READ)) {
            return FormValidation.ok();
        }
        HashSet<String> uniq = new HashSet<String>();
        ArrayList<String> uniqRepor = new ArrayList<String>(configurations.size());
        for (RpmsReportOneRecord configuration : configurations) {
            String value = configuration.getId();
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.error((String)"ID must not be empty (and must be unique)");
            }
            if (!value.matches("[a-zA-Z0-9]+")) {
                return FormValidation.error((String)("ID must be just letters a-zA-Z0-9 (and must be unique). Is " + value));
            }
            uniq.add(value);
            uniqRepor.add(value);
        }
        if (uniq.size() != configurations.size()) {
            return FormValidation.error((String)("IDs must be unique. Are:" + ((Object)uniqRepor).toString()));
        }
        return FormValidation.ok();
    }

    @RequirePOST
    public FormValidation doValidateIds(@QueryParameter List<RpmsReportOneRecord> configurations) {
        if (!Jenkins.get().hasPermission(Jenkins.READ)) {
            return FormValidation.ok();
        }
        try {
            return this.doCheckConfigurations(configurations);
        }
        catch (Exception e) {
            return FormValidation.error((String)("Client error : " + e.getMessage()));
        }
    }

    public BuildStepDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public List<RpmsReportOneRecord> getConfigurations() {
        this.validateId();
        return this.configurations;
    }

    public int getBuildstopast() {
        return this.buildstopast <= 0 ? 10 : this.buildstopast;
    }

    public boolean isMovefailed() {
        return this.movefailed;
    }

    public boolean isMoveunstable() {
        return this.moveunstable;
    }

    public boolean isMoveempty() {
        return this.moveempty;
    }

    @DataBoundSetter
    public void setConfigurations(List<RpmsReportOneRecord> configurations) {
        this.configurations = configurations;
        this.validateId();
    }

    @DataBoundSetter
    public void setBuildstopast(int buildstopast) {
        this.buildstopast = buildstopast;
    }

    @DataBoundSetter
    public void setMoveunstable(boolean moveunstable) {
        this.moveunstable = moveunstable;
    }

    @DataBoundSetter
    public void setMovefailed(boolean movefailed) {
        this.movefailed = movefailed;
    }

    @DataBoundSetter
    public void setMoveempty(boolean moveempty) {
        this.moveempty = moveempty;
    }

    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        public String getDisplayName() {
            return "Diff chart report";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

