/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.genericdiff;

import hudson.model.Job;
import hudson.model.Run;
import io.jenkins.plugins.report.genericdiff.Constants;
import io.jenkins.plugins.report.genericdiff.RpmsReportChartPoint;
import io.jenkins.plugins.report.genericdiff.RpmsReportOneRecord;
import io.jenkins.plugins.report.genericdiff.RpmsReportPublisher;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RpmsReportProjectActionOneChart {
    private final RpmsReportOneRecord publisher;
    private final RpmsReportPublisher parent;
    private final Job<?, ?> job;

    public RpmsReportProjectActionOneChart(RpmsReportOneRecord publisher, RpmsReportPublisher parent, Job<?, ?> job) {
        this.publisher = publisher;
        this.parent = parent;
        this.job = job;
    }

    public String getDisplayName() {
        return this.publisher.getMaintitle();
    }

    public List<RpmsReportChartPoint> getChartData() {
        ArrayList<RpmsReportChartPoint> list = new ArrayList<RpmsReportChartPoint>();
        for (Run run : this.job.getBuilds()) {
            File allFile = new File(run.getRootDir(), Constants.getALL(this.publisher.getId()));
            if (!this.checkFile(allFile)) continue;
            list.add(new RpmsReportChartPoint(run.getNumber(), run.getDisplayName(), this.fileLines(new File(run.getRootDir(), Constants.getNEW(this.publisher.getId()))), this.fileLines(new File(run.getRootDir(), Constants.getREMOVED(this.publisher.getId()))), this.fileLines(allFile)));
            if (list.size() != this.parent.getBuildstopast()) continue;
            break;
        }
        Collections.reverse(list);
        return list;
    }

    private boolean checkFile(File f) {
        return f.exists() && f.isFile() && f.canRead();
    }

    private int fileLines(File f) {
        if (this.checkFile(f)) {
            try {
                int number = Files.readAllLines(f.toPath()).size();
                return number;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public String getChartInstalled() {
        return this.publisher.getAddedlinesshort();
    }

    public String getChartTotal() {
        return this.publisher.getAlllinesshort();
    }

    public String getChartRemoved() {
        return this.publisher.getRemovedlinesshort();
    }

    public String getId() {
        return this.publisher.getId();
    }
}

