/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.report.genericdiff;

import hudson.remoting.VirtualChannel;
import io.jenkins.plugins.report.genericdiff.OperationFailedException;
import io.jenkins.plugins.report.genericdiff.StringSpliterator;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import jenkins.MasterToSlaveFileCallable;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tukaani.xz.XZInputStream;

public class CommandCallable
extends MasterToSlaveFileCallable<List<String>> {
    private static final Logger LOG = LoggerFactory.getLogger(CommandCallable.class);
    private static final Map<String, ArchiveFactory> SUPPORTED_ARCHIVE_TYPES_MAP = CommandCallable.createSupportedArchiveTypesMap();
    private final String command;

    public CommandCallable(String command) {
        if (command == null || command.trim().isEmpty()) {
            throw new IllegalArgumentException("No command specified");
        }
        this.command = command;
    }

    public List<String> invoke(File f, VirtualChannel vchannel) throws IOException, InterruptedException {
        try {
            String stdout = null;
            File kandidateFile = new File(f, this.command.trim());
            if (kandidateFile.exists()) {
                LOG.info("Reading " + this.command.trim() + " (" + kandidateFile.getAbsolutePath() + ")");
                stdout = this.FileToString(kandidateFile);
            } else if (CommandCallable.mayBeArchive(kandidateFile) != null) {
                LOG.info("Getting from archive " + this.command.trim());
                stdout = CommandCallable.fileFromArchiveToString(kandidateFile);
            } else {
                LOG.info("Executing `" + this.command.trim() + "` in" + f.toString() + " (" + f.getAbsolutePath() + ")");
                Process process = new ProcessBuilder(this.command.trim().split(" ")).directory(f).start();
                OutputReader stdoutReader = new OutputReader(this.command, process.getInputStream()).start();
                OutputReader stderrReader = new OutputReader(this.command, process.getErrorStream()).start();
                if (!process.waitFor(60L, TimeUnit.SECONDS)) {
                    throw new OperationFailedException("Command time out");
                }
                LOG.info("Returned " + process.exitValue());
                Thread.sleep(10L);
                try {
                    process.getInputStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    process.getErrorStream().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Thread.sleep(10L);
                LOG.info("sout read " + stdoutReader.getBytes());
                LOG.info("serr read " + stderrReader.getBytes());
                if (stderrReader.getResult() != null) {
                    throw new OperationFailedException(stderrReader.getResult());
                }
                stdout = stdoutReader.getResult();
            }
            if (stdout == null) {
                throw new OperationFailedException("Command produced no output");
            }
            List<String> list = StringSpliterator.splitString(stdout, "\n").filter(s -> s != null && s.length() > 0).sorted().collect(Collectors.toList());
            return list;
        }
        catch (OperationFailedException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new OperationFailedException(ex.toString());
        }
    }

    private String FileToString(File filePath) throws IOException {
        try (FileInputStream fis = new FileInputStream(filePath);){
            String string = CommandCallable.readStream(fis);
            return string;
        }
    }

    private static String compressionType(File path) {
        for (Map.Entry<String, ArchiveFactory> factory : SUPPORTED_ARCHIVE_TYPES_MAP.entrySet()) {
            String pathName = path.toString();
            if (!pathName.toLowerCase().endsWith(factory.getKey())) continue;
            return factory.getKey();
        }
        return null;
    }

    private static File mayBeArchive(File filePath) throws IOException {
        while (filePath != null) {
            if (filePath.exists() && filePath.isFile()) {
                if (CommandCallable.compressionType(filePath) != null) {
                    return filePath;
                }
                return null;
            }
            filePath = filePath.getParentFile();
        }
        return null;
    }

    private static Map<String, ArchiveFactory> createSupportedArchiveTypesMap() {
        HashMap<String, ArchiveFactory> map = new HashMap<String, ArchiveFactory>();
        map.put(".zip", in -> new ZipArchiveInputStream(in));
        map.put(".tar", in -> new TarArchiveInputStream(in));
        map.put(".tar.gz", in -> new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(in)));
        map.put(".tar.bz2", in -> new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(in)));
        map.put(".tar.xz", in -> new TarArchiveInputStream((InputStream)new XZInputStream(in)));
        return Collections.unmodifiableMap(map);
    }

    private static ArchiveInputStream streamPath(File path) throws IOException {
        for (Map.Entry<String, ArchiveFactory> factory : SUPPORTED_ARCHIVE_TYPES_MAP.entrySet()) {
            String pathName = path.toString().toLowerCase();
            if (!pathName.endsWith(factory.getKey())) continue;
            BufferedInputStream stream = new BufferedInputStream(Files.newInputStream(path.toPath(), new OpenOption[0]));
            return factory.getValue().create(stream);
        }
        throw new IOException("Unsupported archive format: " + String.valueOf(path));
    }

    private static String fileFromArchiveToString(File filePath) throws IOException {
        File archiveFilePath = CommandCallable.mayBeArchive(filePath);
        String archiveItem = filePath.toString().replace(archiveFilePath.toString(), "");
        while (archiveItem.startsWith("/") || archiveItem.startsWith("\\")) {
            archiveItem = archiveItem.substring(1);
        }
        try (ArchiveInputStream in = CommandCallable.streamPath(archiveFilePath);){
            ArchiveEntry entry;
            while ((entry = in.getNextEntry()) != null) {
                if (entry.isDirectory() || !entry.getName().equals(archiveItem)) continue;
                String string = CommandCallable.readStream((InputStream)new CloseShieldInputStream((InputStream)in));
                return string;
            }
        }
        throw new IOException("Item " + archiveItem + " not found in " + String.valueOf(archiveFilePath));
    }

    public static String readStream(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder(512);
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is, "UTF-8"));){
            String s;
            while ((s = br.readLine()) != null) {
                sb.append(s).append("\n");
            }
        }
        return sb.toString();
    }

    private static class OutputReader
    implements Runnable {
        private final String command;
        private final InputStream stream;
        private String result;
        private int bytes = 0;

        public OutputReader(String command, InputStream stream) {
            this.command = command;
            this.stream = stream;
        }

        public String getResult() {
            return this.result;
        }

        public int getBytes() {
            return this.bytes;
        }

        @Override
        public void run() {
            try (InputStreamReader in = new InputStreamReader(this.stream, "UTF-8");){
                int read;
                StringBuilder sb = new StringBuilder();
                char[] buffer = new char[8192];
                while ((read = in.read(buffer)) != -1) {
                    this.bytes += read;
                    sb.append(buffer, 0, read);
                }
                if (sb.length() > 0) {
                    this.result = sb.toString();
                }
            }
            catch (Exception ex) {
                this.result = ex.toString();
            }
        }

        public OutputReader start() {
            Thread t = new Thread(this);
            t.setPriority(1);
            t.setName("RPMs Report - Output Reader - '" + this.command + "'");
            t.start();
            return this;
        }
    }

    @FunctionalInterface
    private static interface ArchiveFactory {
        public ArchiveInputStream create(InputStream var1) throws IOException;
    }
}

