/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remotingkafka.commandtransport;

import hudson.remoting.AbstractByteBufferCommandTransport;
import hudson.remoting.Capability;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaByteBufferCommandTransport
extends AbstractByteBufferCommandTransport {
    private static final Logger LOGGER = Logger.getLogger(KafkaByteBufferCommandTransport.class.getName());
    private final Capability remoteCapability;
    private final Producer<String, ByteBuffer> producer;
    private final Consumer<String, ByteBuffer> consumer;
    private final String topic;
    private final String key;

    public KafkaByteBufferCommandTransport(Capability remoteCapability, String topic, String key, Producer<String, ByteBuffer> producer, Consumer<String, ByteBuffer> consumer) {
        this.remoteCapability = remoteCapability;
        this.producer = producer;
        this.consumer = consumer;
        this.topic = topic;
        this.key = key;
    }

    protected void write(ByteBuffer header, ByteBuffer data) throws IOException {
        this.producer.send(new ProducerRecord(this.topic, (Object)this.key, (Object)header));
        this.producer.send(new ProducerRecord(this.topic, (Object)this.key, (Object)data));
    }

    public Capability getRemoteCapability() throws IOException {
        return this.remoteCapability;
    }

    public void closeWrite() throws IOException {
    }

    public void closeRead() throws IOException {
        this.consumer.commitSync();
        this.consumer.close();
    }
}

