/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remotingkafka.builder;

import io.jenkins.plugins.remotingkafka.enums.SecurityProtocol;
import io.jenkins.plugins.remotingkafka.exception.RemotingKafkaSecurityException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;

public class SecurityPropertiesBuilder {
    private static final Logger LOGGER = Logger.getLogger(SecurityPropertiesBuilder.class.getName());
    @CheckForNull
    private String sslTruststoreLocation;
    @CheckForNull
    private String sslTruststorePassword;
    @CheckForNull
    private String sslKeystoreLocation;
    @CheckForNull
    private String sslKeystorePassword;
    @CheckForNull
    private String sslKeyPassword;
    @CheckForNull
    private String saslJassConfig;
    @CheckForNull
    private SecurityProtocol securityProtocol;
    @CheckForNull
    private String saslMechanism;

    public SecurityPropertiesBuilder withSSLTruststoreLocation(String location) {
        this.sslTruststoreLocation = location;
        return this;
    }

    public SecurityPropertiesBuilder withSSLTruststorePassword(String password) {
        this.sslTruststorePassword = password;
        return this;
    }

    public SecurityPropertiesBuilder withSSLKeystoreLocation(String location) {
        this.sslKeystoreLocation = location;
        return this;
    }

    public SecurityPropertiesBuilder withSSLKeystorePassword(String password) {
        this.sslKeystorePassword = password;
        return this;
    }

    public SecurityPropertiesBuilder withSSLKeyPassword(String password) {
        this.sslKeyPassword = password;
        return this;
    }

    public SecurityPropertiesBuilder withSASLJassConfig(String username, String password) {
        this.saslJassConfig = "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"" + username + "\" password=\"" + password + "\";";
        return this;
    }

    public SecurityPropertiesBuilder withSecurityProtocol(SecurityProtocol protocol) {
        this.securityProtocol = protocol;
        return this;
    }

    public SecurityPropertiesBuilder withSASLMechanism(String mechanism) {
        this.saslMechanism = mechanism;
        return this;
    }

    private void put(Properties props, String key, Object value) throws RemotingKafkaSecurityException {
        if (value == null) {
            throw new RemotingKafkaSecurityException("Please provide " + key);
        }
        props.put(key, value);
    }

    public Properties build() throws RemotingKafkaSecurityException {
        Properties props = new Properties();
        this.put(props, "ssl.keystore.location", this.sslKeystoreLocation);
        this.put(props, "ssl.keystore.password", this.sslKeystorePassword);
        this.put(props, "ssl.truststore.location", this.sslTruststoreLocation);
        this.put(props, "ssl.truststore.password", this.sslTruststorePassword);
        this.put(props, "ssl.key.password", this.sslKeyPassword);
        this.put(props, "sasl.jaas.config", this.saslJassConfig);
        if (this.securityProtocol != null) {
            this.put(props, "security.protocol", this.securityProtocol.toString());
        }
        this.put(props, "sasl.mechanism", this.saslMechanism);
        return props;
    }
}

