/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remotingkafka.builder;

import io.jenkins.plugins.remotingkafka.enums.ProducerAcks;
import io.jenkins.plugins.remotingkafka.exception.RemotingKafkaConfigurationException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;

public class ProducerPropertiesBuilder {
    private static final Logger LOGGER = Logger.getLogger(ProducerPropertiesBuilder.class.getName());
    @CheckForNull
    private String bootstrapServers;
    private ProducerAcks acks;
    @CheckForNull
    private Class keySerializer;
    @CheckForNull
    private Class valueSerializer;
    @CheckForNull
    private Properties securityProps;

    public ProducerPropertiesBuilder withBoostrapServers(String boostrapServers) {
        this.bootstrapServers = boostrapServers;
        return this;
    }

    public ProducerPropertiesBuilder withAcks(ProducerAcks acks) {
        this.acks = acks;
        return this;
    }

    public ProducerPropertiesBuilder withKeySerializer(Class keySerializer) {
        this.keySerializer = keySerializer;
        return this;
    }

    public ProducerPropertiesBuilder withValueSerialier(Class valueSerialier) {
        this.valueSerializer = valueSerialier;
        return this;
    }

    public ProducerPropertiesBuilder withSecurityProps(Properties props) {
        this.securityProps = props;
        return this;
    }

    public Properties build() throws RemotingKafkaConfigurationException {
        Properties props;
        Properties properties = props = this.securityProps == null ? new Properties() : this.securityProps;
        if (this.bootstrapServers == null) {
            throw new RemotingKafkaConfigurationException("Please provide Kafka producer bootstrap servers");
        }
        props.put("bootstrap.servers", this.bootstrapServers);
        if (this.acks != null) {
            props.put("acks", this.acks.toString());
        }
        if (this.keySerializer == null) {
            throw new RemotingKafkaConfigurationException("Please provide key serializer class");
        }
        props.put("key.serializer", this.keySerializer);
        if (this.valueSerializer == null) {
            throw new RemotingKafkaConfigurationException("Please provide value serializer class");
        }
        props.put("value.serializer", this.valueSerializer);
        return props;
    }
}

