/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remotingkafka.builder;

import hudson.remoting.Capability;
import io.jenkins.plugins.remotingkafka.commandtransport.KafkaClassicCommandTransport;
import io.jenkins.plugins.remotingkafka.exception.RemotingKafkaTransportException;
import javax.annotation.CheckForNull;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.producer.Producer;

public class KafkaTransportBuilder {
    @CheckForNull
    private Capability remoteCapability;
    @CheckForNull
    private Producer<String, byte[]> producer;
    @CheckForNull
    private Consumer<String, byte[]> consumer;
    @CheckForNull
    private String producerTopic;
    @CheckForNull
    private String producerKey;
    @CheckForNull
    private String consumerTopic;
    @CheckForNull
    private String consumerKey;
    private long pollTimeout;
    private int producerPartition;
    private int consumerPartition;

    public KafkaTransportBuilder withRemoteCapability(Capability cap) {
        this.remoteCapability = cap;
        return this;
    }

    public KafkaTransportBuilder withProducer(Producer<String, byte[]> producer) {
        this.producer = producer;
        return this;
    }

    public KafkaTransportBuilder withConsumer(Consumer<String, byte[]> consumer) {
        this.consumer = consumer;
        return this;
    }

    public KafkaTransportBuilder withProducerTopic(String producerTopic) {
        this.producerTopic = producerTopic;
        return this;
    }

    public KafkaTransportBuilder withProducerKey(String producerKey) {
        this.producerKey = producerKey;
        return this;
    }

    public KafkaTransportBuilder withConsumerTopic(String consumerTopic) {
        this.consumerTopic = consumerTopic;
        return this;
    }

    public KafkaTransportBuilder withConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
        return this;
    }

    public KafkaTransportBuilder withPollTimeout(long pollTimeout) {
        this.pollTimeout = pollTimeout;
        return this;
    }

    public KafkaTransportBuilder withProducerPartition(int producerPartition) {
        this.producerPartition = producerPartition;
        return this;
    }

    public KafkaTransportBuilder withConsumerPartition(int consumerPartition) {
        this.consumerPartition = consumerPartition;
        return this;
    }

    public KafkaClassicCommandTransport build() throws RemotingKafkaTransportException {
        if (this.remoteCapability == null) {
            throw new RemotingKafkaTransportException("Please provide remote capability");
        }
        if (this.producer == null) {
            throw new RemotingKafkaTransportException("Please provide a producer instance");
        }
        if (this.consumer == null) {
            throw new RemotingKafkaTransportException("Please provide a consumer instance");
        }
        if (this.producerTopic == null) {
            throw new RemotingKafkaTransportException("Please provide a producer topic");
        }
        if (this.producerKey == null) {
            throw new RemotingKafkaTransportException("Please provide a producer key");
        }
        if (this.consumerTopic == null) {
            throw new RemotingKafkaTransportException("Please provide a consumer topic");
        }
        if (this.consumerKey == null) {
            throw new RemotingKafkaTransportException("Please provide a consumer key");
        }
        return new KafkaClassicCommandTransport(this);
    }

    @CheckForNull
    public Capability getRemoteCapability() {
        return this.remoteCapability;
    }

    @CheckForNull
    public Producer<String, byte[]> getProducer() {
        return this.producer;
    }

    @CheckForNull
    public Consumer<String, byte[]> getConsumer() {
        return this.consumer;
    }

    @CheckForNull
    public String getProducerTopic() {
        return this.producerTopic;
    }

    @CheckForNull
    public String getProducerKey() {
        return this.producerKey;
    }

    @CheckForNull
    public String getConsumerTopic() {
        return this.consumerTopic;
    }

    @CheckForNull
    public String getConsumerKey() {
        return this.consumerKey;
    }

    public long getPollTimeout() {
        return this.pollTimeout;
    }

    public int getProducerPartition() {
        return this.producerPartition;
    }

    public int getConsumerPartition() {
        return this.consumerPartition;
    }
}

