/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remotingkafka.builder;

import io.jenkins.plugins.remotingkafka.enums.AutoOffsetReset;
import io.jenkins.plugins.remotingkafka.exception.RemotingKafkaConfigurationException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.CheckForNull;

public class ConsumerPropertiesBuilder {
    private static final Logger LOGGER = Logger.getLogger(ConsumerPropertiesBuilder.class.getName());
    @CheckForNull
    private String bootstrapServers;
    private boolean enableAutoCommit = true;
    private String groupID;
    private AutoOffsetReset autoOffsetReset;
    @CheckForNull
    private Class keyDeserializer;
    @CheckForNull
    private Class valueDeserializer;
    @CheckForNull
    private Properties securityProps;

    public ConsumerPropertiesBuilder withBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
        return this;
    }

    public ConsumerPropertiesBuilder withEnableAutoCommit(boolean enableAutoCommit) {
        this.enableAutoCommit = enableAutoCommit;
        return this;
    }

    public ConsumerPropertiesBuilder withGroupID(String groupID) {
        this.groupID = groupID;
        return this;
    }

    public ConsumerPropertiesBuilder withAutoOffsetReset(AutoOffsetReset autoOffsetReset) {
        this.autoOffsetReset = autoOffsetReset;
        return this;
    }

    public ConsumerPropertiesBuilder withKeyDeserializer(Class keyDeserializer) {
        this.keyDeserializer = keyDeserializer;
        return this;
    }

    public ConsumerPropertiesBuilder withValueDeserializer(Class valueDeserializer) {
        this.valueDeserializer = valueDeserializer;
        return this;
    }

    public ConsumerPropertiesBuilder withSecurityProps(Properties props) {
        this.securityProps = props;
        return this;
    }

    public Properties build() throws RemotingKafkaConfigurationException {
        Properties props;
        Properties properties = props = this.securityProps == null ? new Properties() : this.securityProps;
        if (this.bootstrapServers == null) {
            throw new RemotingKafkaConfigurationException("Please provide Kafka consumer bootstrap servers");
        }
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("enable.auto.commit", (Object)this.enableAutoCommit);
        if (this.groupID != null) {
            props.put("group.id", this.groupID);
        }
        if (this.autoOffsetReset != null) {
            props.put("auto.offset.reset", this.autoOffsetReset.toString());
        }
        if (this.keyDeserializer == null) {
            throw new RemotingKafkaConfigurationException("Please provide key deserializer class");
        }
        props.put("key.deserializer", this.keyDeserializer);
        if (this.valueDeserializer == null) {
            throw new RemotingKafkaConfigurationException("Please provide value deserializer class");
        }
        props.put("value.deserializer", this.valueDeserializer);
        return props;
    }
}

