/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remotingkafka;

import io.jenkins.plugins.remotingkafka.builder.ConsumerPropertiesBuilder;
import io.jenkins.plugins.remotingkafka.builder.ProducerPropertiesBuilder;
import io.jenkins.plugins.remotingkafka.enums.AutoOffsetReset;
import io.jenkins.plugins.remotingkafka.enums.ProducerAcks;
import io.jenkins.plugins.remotingkafka.exception.RemotingKafkaConfigurationException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import kafka.admin.AdminUtils;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.ZkConnection;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class KafkaUtils {
    private static final Logger LOGGER = Logger.getLogger(KafkaUtils.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Producer<String, byte[]> createByteProducer(String kafkaURL, @Nullable Properties securityProps) throws RemotingKafkaConfigurationException {
        Properties producerProps = new ProducerPropertiesBuilder().withBoostrapServers(kafkaURL).withAcks(ProducerAcks.ALL).withKeySerializer(StringSerializer.class).withValueSerialier(ByteArraySerializer.class).withSecurityProps(securityProps).build();
        KafkaProducer producer = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(KafkaProducer.class.getClassLoader());
            producer = new KafkaProducer(producerProps);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception when creating a Kafka producer", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KafkaConsumer<String, byte[]> createByteConsumer(String kafkaURL, String consumerGroupID, @Nullable Properties securityProps) throws RemotingKafkaConfigurationException {
        Properties consumerProps = new ConsumerPropertiesBuilder().withBootstrapServers(kafkaURL).withGroupID(consumerGroupID).withEnableAutoCommit(false).withAutoOffsetReset(AutoOffsetReset.EARLIEST).withKeyDeserializer(StringDeserializer.class).withValueDeserializer(ByteArrayDeserializer.class).withSecurityProps(securityProps).build();
        KafkaConsumer consumer = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(KafkaConsumer.class.getClassLoader());
            consumer = new KafkaConsumer(consumerProps);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception when creating a Kafka consumer", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
        return consumer;
    }

    public static void unassignConsumer(Consumer<String, byte[]> consumer) {
        consumer.assign(new ArrayList());
        consumer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createTopic(String topic, String zookeeperHost, int noOfPartitions, int noOfReplication) {
        try (ZkClient zkClient = null;){
            int sessionTimeOutInMs = 15000;
            int connectionTimeOutInMs = 10000;
            zkClient = new ZkClient(zookeeperHost, sessionTimeOutInMs, connectionTimeOutInMs, (ZkSerializer)ZKStringSerializer$.MODULE$);
            ZkUtils zkUtils = new ZkUtils(zkClient, new ZkConnection(zookeeperHost), false);
            Properties topicConfiguration = new Properties();
            AdminUtils.createTopic((ZkUtils)zkUtils, (String)topic, (int)noOfPartitions, (int)noOfReplication, (Properties)topicConfiguration, null);
        }
    }
}

