/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remotingkafka;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;

public class KafkaProducerClient {
    private static final Logger LOGGER = Logger.getLogger(KafkaProducerClient.class.getName());
    private static volatile KafkaProducerClient instance;
    private volatile Producer<String, byte[]> byteProducer;

    private KafkaProducerClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KafkaProducerClient getInstance() {
        if (instance != null) return instance;
        Class<KafkaProducerClient> clazz = KafkaProducerClient.class;
        synchronized (KafkaProducerClient.class) {
            if (instance != null) return instance;
            instance = new KafkaProducerClient();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Producer<String, byte[]> getByteProducer(Properties producerProps) {
        if (this.byteProducer != null) return this.byteProducer;
        Class<KafkaProducerClient> clazz = KafkaProducerClient.class;
        synchronized (KafkaProducerClient.class) {
            if (this.byteProducer != null) return this.byteProducer;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(KafkaProducer.class.getClassLoader());
                this.byteProducer = new KafkaProducer(producerProps);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Exception when creating a Kafka producer", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(cl);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.byteProducer;
        }
    }
}

