/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remotingkafka;

import java.net.URL;

public class KafkaConfigs {
    public static final String BOOTSTRAP_SERVERS = "bootstrap.servers";
    public static final String SASL_JAAS_CONFIG = "sasl.jaas.config";
    public static final String SECURITY_PROTOCOL = "security.protocol";
    public static final String SASL_MECHANISM = "sasl.mechanism";
    public static final String SSL_TRUSTSTORE_LOCATION = "ssl.truststore.location";
    public static final String SSL_TRUSTSTORE_PASSWORD = "ssl.truststore.password";
    public static final String SSL_KEYSTORE_LOCATION = "ssl.keystore.location";
    public static final String SSL_KEYSTORE_PASSWORD = "ssl.keystore.password";
    public static final String SSL_KEY_PASSWORD = "ssl.key.password";
    public static final String KEY_SERIALIZER = "key.serializer";
    public static final String VALUE_SERIALIZER = "value.serializer";
    public static final String ACKS = "acks";
    public static final String GROUP_ID = "group.id";
    public static final String ENABLE_AUTO_COMMIT = "enable.auto.commit";
    public static final String KEY_DESERIALIZER = "key.deserializer";
    public static final String VALUE_DESERIALIZER = "value.deserializer";
    public static final String AUTO_OFFSET_RESET = "auto.offset.reset";
    public static final int MASTER_AGENT_CMD_PARTITION = 0;
    public static final int AGENT_MASTER_CMD_PARTITION = 1;
    public static final int MASTER_AGENT_SECRET_PARTITION = 2;
    public static final int AGENT_MASTER_SECRET_PARTITION = 3;
    private static final String DELIMITER = ".";
    private static final String TOPIC_SUFFIX = "-topic";
    private static final String CONSUMER_GROUP_SUFFIX = "-id";
    private static final String COMMAND_SUFFIX = "-command";
    private static final String SECRET_SUFFIX = "-secret";

    public static String getConnectionTopic(String agentName, URL masterURL) {
        return masterURL.getHost() + DELIMITER + masterURL.getPort() + DELIMITER + agentName + TOPIC_SUFFIX;
    }

    public static String getConsumerGroupID(String agentName, URL masterURL) {
        return masterURL.getHost() + DELIMITER + masterURL.getPort() + DELIMITER + agentName + CONSUMER_GROUP_SUFFIX;
    }

    public static String getMasterAgentCommandKey(String agentName, URL masterURL) {
        return masterURL.getHost() + DELIMITER + masterURL.getPort() + DELIMITER + agentName + COMMAND_SUFFIX;
    }

    public static String getAgentMasterCommandKey(String agentName, URL masterURL) {
        return agentName + DELIMITER + masterURL.getHost() + DELIMITER + masterURL.getPort() + COMMAND_SUFFIX;
    }

    public static String getMasterAgentSecretKey(String agentName, URL masterURL) {
        return masterURL.getHost() + DELIMITER + masterURL.getPort() + DELIMITER + agentName + SECRET_SUFFIX;
    }

    public static String getAgentMasterSecretKey(String agentName, URL masterURL) {
        return agentName + DELIMITER + masterURL.getHost() + DELIMITER + masterURL.getPort() + COMMAND_SUFFIX;
    }
}

