/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remotingkafka;

import io.jenkins.plugins.remotingkafka.KafkaUtils;
import io.jenkins.plugins.remotingkafka.builder.KafkaTransportBuilder;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.logging.Logger;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;

public final class KafkaClientListener
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(KafkaClientListener.class.getName());
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final String inMessage;
    private final String outMessage;
    private final String producerTopic;
    private final String producerKey;
    private final String consumerTopic;
    private final String consumerKey;
    private final int producerPartition;
    private final int consumerPartition;
    private Producer<String, byte[]> producer;
    private Consumer<String, byte[]> consumer;
    private volatile boolean shuttingDown;

    public KafkaClientListener(String inMessage, String outMessage, KafkaTransportBuilder settings) {
        this.inMessage = inMessage;
        this.outMessage = outMessage;
        this.producerTopic = settings.getProducerTopic();
        this.producerKey = settings.getProducerKey();
        this.consumerKey = settings.getConsumerKey();
        this.consumerTopic = settings.getConsumerTopic();
        this.producerPartition = settings.getProducerPartition();
        this.consumerPartition = settings.getConsumerPartition();
        this.producer = settings.getProducer();
        this.consumer = settings.getConsumer();
    }

    @Override
    public void run() {
        LOGGER.info("Kafka client listener is running...");
        while (!this.shuttingDown) {
            String receivedMessage;
            TopicPartition partition = new TopicPartition(this.consumerTopic, this.consumerPartition);
            this.consumer.assign(Arrays.asList(partition));
            do {
                ConsumerRecords records = this.consumer.poll(0L);
                this.consumer.commitSync();
                receivedMessage = "";
                for (ConsumerRecord record : records) {
                    if (!((String)record.key()).equals(this.consumerKey)) continue;
                    receivedMessage = new String((byte[])record.value(), UTF_8);
                }
            } while (!receivedMessage.equals(this.inMessage));
            this.producer.send(new ProducerRecord(this.producerTopic, Integer.valueOf(this.producerPartition), (Object)this.producerKey, (Object)this.outMessage.getBytes(UTF_8)));
        }
        if (this.producer != null) {
            this.producer.close();
        }
        if (this.consumer != null) {
            KafkaUtils.unassignConsumer(this.consumer);
        }
    }
}

