/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.remote.result.trigger;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Item;
import io.jenkins.plugins.remote.result.trigger.model.JobResultDisplayInfo;
import io.jenkins.plugins.remote.result.trigger.model.JobResultInfo;
import io.jenkins.plugins.remote.result.trigger.utils.RemoteJobResultUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.jelly.XMLOutput;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class RemoteBuildResultTriggerProjectAction
implements Action {
    private final BuildableItem job;
    private final File logFile;

    public RemoteBuildResultTriggerProjectAction(BuildableItem job, File logFile) {
        this.job = job;
        this.logFile = logFile;
    }

    public List<JobResultDisplayInfo> getJobResultDisplayInfos() throws IOException {
        ObjectWriter jsonPretty = new ObjectMapper().writerWithDefaultPrettyPrinter();
        List<JobResultInfo> jobResultInfos = RemoteJobResultUtils.getSavedJobInfos((Item)this.job);
        ArrayList<JobResultDisplayInfo> results = new ArrayList<JobResultDisplayInfo>();
        for (JobResultInfo jobResultInfo : jobResultInfos) {
            JobResultDisplayInfo info = new JobResultDisplayInfo();
            info.setRemoteJobUrl(jobResultInfo.getRemoteJobUrl());
            info.setBuildUrl(jobResultInfo.getBuildUrl());
            info.setResult(jsonPretty.writeValueAsString(jobResultInfo.getBuildResult()));
            if (jobResultInfo.getRemoteResult() != null) {
                info.setResultJson(jsonPretty.writeValueAsString(jobResultInfo.getRemoteResult()));
            }
            results.add(info);
        }
        return results;
    }

    @RequirePOST
    public void doClean() throws IOException {
        RemoteJobResultUtils.cleanCache(this.job);
    }

    public String getIconFileName() {
        return "symbol-details";
    }

    public String getDisplayName() {
        return "Remote Result Trigger";
    }

    public String getUrlName() {
        return "remote-result-trigger";
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED"})
    public void writeLogTo(XMLOutput out) throws IOException {
        new AnnotatedLargeText(this.logFile, StandardCharsets.UTF_8, true, (Object)this).writeHtmlTo(0L, out.asWriter());
    }

    public String getLog() throws IOException {
        return Util.loadFile((File)this.logFile, (Charset)StandardCharsets.UTF_8);
    }

    public BuildableItem getOwner() {
        return this.job;
    }
}

