/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.cards;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface RunDetailsItem {

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface ItemContent {
        public static ItemContent of(@NonNull String text) {
            return new PlainContent(text);
        }

        public static ItemContent of(String href, @NonNull String text) {
            return href == null || href.isBlank() ? new PlainContent(text) : new LinkContent(href, text);
        }

        public record PlainContent(@NonNull String text) implements ItemContent
        {
            public PlainContent {
                Objects.requireNonNull(text);
            }
        }

        public record LinkContent(@NonNull String href, @NonNull String text) implements ItemContent
        {
            public LinkContent {
                Objects.requireNonNull(href);
                Objects.requireNonNull(text);
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Icon {
        public String value();

        public record Ionicon(@NonNull String value) implements Icon
        {
            public Ionicon(@NonNull String value) {
                Objects.requireNonNull(value);
                this.value = String.format("symbol-%s plugin-ionicons-api", value);
            }
        }
    }

    public static final class RunDetail
    implements RunDetailsItem {
        @NonNull
        private final Icon icon;
        @NonNull
        private final ItemContent content;
        @Nullable
        private final String tooltip;

        public RunDetail(@NonNull Icon icon, @NonNull ItemContent content, @Nullable String tooltip) {
            this.icon = Objects.requireNonNull(icon);
            this.content = Objects.requireNonNull(content);
            this.tooltip = tooltip;
        }

        public RunDetail(@NonNull Icon icon, @NonNull ItemContent content) {
            this(icon, content, null);
        }

        @Nullable
        public String tooltip() {
            return this.tooltip;
        }

        @NonNull
        public ItemContent content() {
            return this.content;
        }

        @NonNull
        public String icon() {
            return this.icon.value();
        }
    }
}

