/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.pipelinegraphview.utils;

import io.jenkins.plugins.pipelinegraphview.treescanner.PipelineNodeGraphAdapter;
import io.jenkins.plugins.pipelinegraphview.utils.FlowNodeWrapper;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineState;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStep;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepBuilderApi;
import io.jenkins.plugins.pipelinegraphview.utils.PipelineStepList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.workflow.job.WorkflowRun;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineStepApi {
    private static final Logger logger = LoggerFactory.getLogger(PipelineStepApi.class);
    private final transient WorkflowRun run;

    public PipelineStepApi(WorkflowRun run) {
        this.run = run;
    }

    private List<PipelineStep> parseSteps(List<FlowNodeWrapper> stepNodes, String stageId) {
        if (logger.isDebugEnabled()) {
            logger.debug("PipelineStepApi steps: '{}'.", stepNodes);
        }
        return stepNodes.stream().map(flowNodeWrapper -> {
            String displayName = flowNodeWrapper.getDisplayName();
            String title = "";
            if (flowNodeWrapper.getType() == FlowNodeWrapper.NodeType.UNHANDLED_EXCEPTION) {
                displayName = "Pipeline error";
            } else {
                String labelDisplayName;
                String stepArguments = flowNodeWrapper.getArgumentsAsString();
                if (stepArguments != null && !stepArguments.isEmpty()) {
                    displayName = stepArguments;
                    title = flowNodeWrapper.getDisplayName();
                }
                if ((labelDisplayName = flowNodeWrapper.getLabelDisplayName()) != null && !labelDisplayName.isEmpty()) {
                    displayName = labelDisplayName;
                    title = "";
                }
            }
            logger.debug("DisplayName Before: '{}'.", (Object)displayName);
            displayName = PipelineStepApi.cleanTextContent(displayName);
            logger.debug("DisplayName After: '{}'.", (Object)displayName);
            if (!displayName.isBlank() && (title.equals("Shell Script") || title.equals("Print Message"))) {
                title = "";
            }
            return new PipelineStep(flowNodeWrapper.getId(), displayName, PipelineState.of(flowNodeWrapper.getStatus()), flowNodeWrapper.getType().name(), title, stageId, flowNodeWrapper.getTiming());
        }).collect(Collectors.toList());
    }

    static String cleanTextContent(String text) {
        text = text.replaceAll("\\e\\[(\\d+[;:]?)+m", "");
        return text.trim();
    }

    private PipelineStepList getSteps(String stageId, PipelineStepBuilderApi builder) {
        List<FlowNodeWrapper> stepNodes = builder.getStageSteps(stageId);
        PipelineStepList steps = new PipelineStepList(this.parseSteps(stepNodes, stageId));
        steps.sort();
        return steps;
    }

    private PipelineStepList getAllSteps(PipelineStepBuilderApi builder) {
        Map<String, List<FlowNodeWrapper>> stepNodes = builder.getAllSteps();
        PipelineStepList allSteps = new PipelineStepList();
        for (Map.Entry<String, List<FlowNodeWrapper>> entry : stepNodes.entrySet()) {
            allSteps.addAll(this.parseSteps(entry.getValue(), entry.getKey()));
        }
        allSteps.sort();
        return allSteps;
    }

    public PipelineStepList getSteps(String stageId) {
        return this.getSteps(stageId, new PipelineNodeGraphAdapter(this.run));
    }

    public PipelineStepList getAllSteps() {
        return this.getAllSteps(new PipelineNodeGraphAdapter(this.run));
    }
}

