/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.workflowhttp.cps;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.AbortException;
import hudson.FilePath;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.VirtualChannel;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import jenkins.MasterToSlaveFileCallable;
import jenkins.util.JenkinsJVM;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPut;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.entity.FileEntity;
import org.apache.hc.core5.http.message.StatusLine;

public final class RobustHTTPClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ExecutorService executors = JenkinsJVM.isJenkinsJVM() ? Computer.threadPoolForRemoting : Executors.newCachedThreadPool();
    private int stopAfterAttemptNumber;
    private long waitMultiplier;
    private long waitMaximum;
    private long timeout;

    public RobustHTTPClient() {
        JenkinsJVM.checkJenkinsJVM();
        this.stopAfterAttemptNumber = Integer.getInteger(RobustHTTPClient.class.getName() + ".STOP_AFTER_ATTEMPT_NUMBER", 10);
        this.waitMultiplier = Long.getLong(RobustHTTPClient.class.getName() + ".WAIT_MULTIPLIER", 100L);
        this.waitMaximum = Long.getLong(RobustHTTPClient.class.getName() + ".WAIT_MAXIMUM", TimeUnit.MINUTES.toMillis(5L));
        this.timeout = Long.getLong(RobustHTTPClient.class.getName() + ".TIMEOUT", TimeUnit.MINUTES.toMillis(15L));
    }

    public static String sanitize(URL url) {
        try {
            URI orig = url.toURI();
            return new URI(orig.getScheme(), orig.getUserInfo() != null ? "\u2026" : null, orig.getHost(), orig.getPort(), orig.getPath(), orig.getQuery() != null ? "\u2026" : null, orig.getFragment()).toString();
        }
        catch (URISyntaxException x) {
            assert (false) : x;
            return url.toString();
        }
    }

    public void setStopAfterAttemptNumber(int stopAfterAttemptNumber) {
        this.stopAfterAttemptNumber = stopAfterAttemptNumber;
    }

    public void setWaitMultiplier(long waitMultiplier, TimeUnit unit) {
        this.waitMultiplier = unit.toMillis(waitMultiplier);
    }

    public void setWaitMaximum(long waitMaximum, TimeUnit unit) {
        this.waitMaximum = unit.toMillis(waitMaximum);
    }

    public void setTimeout(long timeout, TimeUnit unit) {
        this.timeout = unit.toMillis(timeout);
    }

    public void connect(String whatConcise, String whatVerbose, @NonNull ConnectionCreator connectionCreator, @NonNull ConnectionUser connectionUser, @NonNull TaskListener listener) throws IOException, InterruptedException {
        AtomicInteger responseCode = new AtomicInteger();
        int attempt = 1;
        while (true) {
            try {
                try {
                    executors.submit(() -> {
                        responseCode.set(0);
                        try (CloseableHttpClient client = HttpClients.createSystem();
                             CloseableHttpResponse response = connectionCreator.connect(client);){
                            StatusLine statusLine = new StatusLine((HttpResponse)response);
                            responseCode.set(statusLine.getStatusCode());
                            if (responseCode.get() < 200 || responseCode.get() >= 300) {
                                String diag;
                                HttpEntity entity = response.getEntity();
                                if (entity != null) {
                                    try (InputStream err = entity.getContent();){
                                        String contentEncoding = entity.getContentEncoding();
                                        diag = IOUtils.toString((InputStream)err, (String)contentEncoding);
                                    }
                                } else {
                                    diag = null;
                                }
                                throw new AbortException(String.format("Failed to %s, response: %d %s, body: %s", whatVerbose, responseCode.get(), statusLine.getReasonPhrase(), diag));
                            }
                            connectionUser.use(response);
                        }
                        return null;
                    }).get(this.timeout, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException x) {
                    throw new ExecutionException(new IOException(x));
                }
                listener.getLogger().flush();
                return;
            }
            catch (ExecutionException wrapped) {
                Throwable x = wrapped.getCause();
                if (x instanceof IOException) {
                    if (attempt == this.stopAfterAttemptNumber) {
                        throw (IOException)x;
                    }
                    Thread.sleep(Math.min((long)Math.pow(2.0, attempt) * this.waitMultiplier, this.waitMaximum));
                    listener.getLogger().printf("Retrying %s after: %s%n", whatConcise, x instanceof AbortException ? x.getMessage() : x.toString());
                    ++attempt;
                    continue;
                }
                if (x instanceof InterruptedException) {
                    throw (InterruptedException)x;
                }
                if (x instanceof RuntimeException) {
                    throw (RuntimeException)x;
                }
                if (x != null) {
                    throw new RuntimeException(x);
                }
                throw new IllegalStateException();
            }
            break;
        }
    }

    public void uploadFile(File f, URL url, TaskListener listener) throws IOException, InterruptedException {
        this.uploadFile(f, null, url, listener);
    }

    public void uploadFile(File f, String contentType, URL url, TaskListener listener) throws IOException, InterruptedException {
        this.connect("upload", "upload " + String.valueOf(f) + " to " + RobustHTTPClient.sanitize(url), client -> {
            HttpPut put = new HttpPut(url.toString());
            put.setEntity((HttpEntity)new FileEntity(f, ContentType.parse((CharSequence)contentType)));
            if (contentType != null) {
                put.setHeader("Content-Type", (Object)contentType);
            }
            return client.execute((ClassicHttpRequest)put);
        }, response -> {}, listener);
    }

    public void downloadFile(File f, URL url, TaskListener listener) throws IOException, InterruptedException {
        this.connect("download", "download " + RobustHTTPClient.sanitize(url) + " to " + String.valueOf(f), client -> client.execute((ClassicHttpRequest)new HttpGet(url.toString())), response -> {
            try (InputStream is = response.getEntity().getContent();){
                FileUtils.copyInputStreamToFile((InputStream)is, (File)f);
            }
        }, listener);
    }

    public void copyFromRemotely(FilePath f, URL url, TaskListener listener) throws IOException, InterruptedException {
        f.act((FilePath.FileCallable)new CopyFromRemotely(this, url, listener));
    }

    @FunctionalInterface
    public static interface ConnectionCreator {
        public CloseableHttpResponse connect(CloseableHttpClient var1) throws IOException, InterruptedException;
    }

    @FunctionalInterface
    public static interface ConnectionUser {
        public void use(CloseableHttpResponse var1) throws IOException, InterruptedException;
    }

    private static final class CopyFromRemotely
    extends MasterToSlaveFileCallable<Void> {
        private static final long serialVersionUID = 1L;
        private final RobustHTTPClient client;
        private final URL u;
        private final TaskListener listener;

        CopyFromRemotely(RobustHTTPClient client, URL u, TaskListener listener) {
            this.client = client;
            this.u = u;
            this.listener = listener;
        }

        public Void invoke(File f, VirtualChannel channel) throws IOException, InterruptedException {
            try {
                this.client.downloadFile(f, this.u, this.listener);
            }
            finally {
                this.listener.getLogger().flush();
            }
            return null;
        }
    }
}

