/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.api;

import com.google.common.annotations.VisibleForTesting;
import io.jenkins.plugins.opentelemetry.api.InstrumentationScope;
import io.opentelemetry.api.incubator.trace.ExtendedSpanBuilder;
import io.opentelemetry.api.incubator.trace.ExtendedTracer;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;

class ReconfigurableTracerProvider
implements TracerProvider {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private TracerProvider delegate;
    private final ConcurrentMap<InstrumentationScope, ReconfigurableExtendedTracer> tracers = new ConcurrentHashMap<InstrumentationScope, ReconfigurableExtendedTracer>();

    public ReconfigurableTracerProvider() {
        this(TracerProvider.noop());
    }

    public ReconfigurableTracerProvider(TracerProvider delegate) {
        this.delegate = delegate;
    }

    public Tracer get(String instrumentationScopeName) {
        this.lock.readLock().lock();
        try {
            Tracer tracer = (Tracer)this.tracers.computeIfAbsent(new InstrumentationScope(instrumentationScopeName), instrumentationScope -> new ReconfigurableExtendedTracer(this.delegate.get(instrumentationScope.instrumentationScopeName), this.lock));
            return tracer;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDelegate(TracerProvider delegate) {
        this.lock.writeLock().lock();
        try {
            this.delegate = delegate;
            this.tracers.forEach((instrumentationScope, reconfigurableExtendedTracer) -> {
                TracerBuilder tracerBuilder = delegate.tracerBuilder(instrumentationScope.instrumentationScopeName);
                Optional.ofNullable(instrumentationScope.instrumentationScopeVersion).ifPresent(arg_0 -> ((TracerBuilder)tracerBuilder).setInstrumentationVersion(arg_0));
                Optional.ofNullable(instrumentationScope.schemaUrl).ifPresent(arg_0 -> ((TracerBuilder)tracerBuilder).setSchemaUrl(arg_0));
                reconfigurableExtendedTracer.setDelegate(tracerBuilder.build());
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tracer get(String instrumentationScopeName, String instrumentationScopeVersion) {
        this.lock.readLock().lock();
        try {
            Tracer tracer = (Tracer)this.tracers.computeIfAbsent(new InstrumentationScope(instrumentationScopeName, null, instrumentationScopeVersion), instrumentationScope -> new ReconfigurableExtendedTracer(this.delegate.get(instrumentationScopeName, instrumentationScopeVersion), this.lock));
            return tracer;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TracerBuilder tracerBuilder(String instrumentationScopeName) {
        this.lock.readLock().lock();
        try {
            ReconfigurableTracerBuilder reconfigurableTracerBuilder = new ReconfigurableTracerBuilder(this.delegate.tracerBuilder(instrumentationScopeName), instrumentationScopeName, this.lock);
            return reconfigurableTracerBuilder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public TracerProvider getDelegate() {
        this.lock.readLock().lock();
        try {
            TracerProvider tracerProvider = this.delegate;
            return tracerProvider;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @VisibleForTesting
    protected class ReconfigurableTracerBuilder
    implements TracerBuilder {
        final TracerBuilder delegate;
        final String instrumentationScopeName;
        String schemaUrl;
        String instrumentationScopeVersion;
        final ReadWriteLock lock;

        public ReconfigurableTracerBuilder(TracerBuilder delegate, String instrumentationScopeName, ReadWriteLock lock) {
            this.delegate = Objects.requireNonNull(delegate);
            this.instrumentationScopeName = Objects.requireNonNull(instrumentationScopeName);
            this.lock = lock;
        }

        public TracerBuilder setSchemaUrl(String schemaUrl) {
            this.delegate.setSchemaUrl(schemaUrl);
            this.schemaUrl = schemaUrl;
            return this;
        }

        public TracerBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
            this.delegate.setInstrumentationVersion(instrumentationScopeVersion);
            this.instrumentationScopeVersion = instrumentationScopeVersion;
            return this;
        }

        public Tracer build() {
            this.lock.readLock().lock();
            try {
                InstrumentationScope instrumentationScope = new InstrumentationScope(this.instrumentationScopeName, this.schemaUrl, this.instrumentationScopeVersion);
                Tracer tracer = (Tracer)ReconfigurableTracerProvider.this.tracers.computeIfAbsent(instrumentationScope, k -> new ReconfigurableExtendedTracer(this.delegate.build(), this.lock));
                return tracer;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @VisibleForTesting
    protected static class ReconfigurableExtendedTracer
    implements ExtendedTracer {
        final ReadWriteLock lock;
        ExtendedTracer delegate;

        public ReconfigurableExtendedTracer(Tracer delegate, ReadWriteLock lock) {
            this.lock = Objects.requireNonNull(lock, "lock");
            this.delegate = Objects.requireNonNull(ReconfigurableExtendedTracer.requiresExtendedTracer(delegate), "delegate");
        }

        private static ExtendedTracer requiresExtendedTracer(Tracer tracer) {
            if (!(tracer instanceof ExtendedTracer)) {
                boolean incubatorAvailable = false;
                try {
                    Class.forName("io.opentelemetry.api.incubator.trace.ExtendedDefaultTracerProvider");
                    incubatorAvailable = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                throw new IllegalStateException("Delegate '" + String.valueOf(tracer) + "' must be an instance of ExtendedTracer. API incubator module is not on the classpath: " + incubatorAvailable);
            }
            return (ExtendedTracer)tracer;
        }

        public ExtendedSpanBuilder spanBuilder(@Nonnull String spanName) {
            this.lock.readLock().lock();
            try {
                ExtendedSpanBuilder extendedSpanBuilder = this.delegate.spanBuilder(spanName);
                return extendedSpanBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setDelegate(Tracer delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = ReconfigurableExtendedTracer.requiresExtendedTracer(delegate);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public ExtendedTracer getDelegate() {
            this.lock.readLock().lock();
            try {
                ExtendedTracer extendedTracer = this.delegate;
                return extendedTracer;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public boolean isEnabled() {
            this.lock.readLock().lock();
            try {
                boolean bl = this.delegate.isEnabled();
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }
}

