/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.opentelemetry.api;

import com.google.common.annotations.VisibleForTesting;
import io.jenkins.plugins.opentelemetry.api.InstrumentationScope;
import io.opentelemetry.api.incubator.logs.ExtendedLogRecordBuilder;
import io.opentelemetry.api.incubator.logs.ExtendedLogger;
import io.opentelemetry.api.logs.Logger;
import io.opentelemetry.api.logs.LoggerBuilder;
import io.opentelemetry.api.logs.LoggerProvider;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

class ReconfigurableLoggerProvider
implements LoggerProvider {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private LoggerProvider delegate;
    private final ConcurrentMap<InstrumentationScope, ReconfigurableExtendedLogger> loggers = new ConcurrentHashMap<InstrumentationScope, ReconfigurableExtendedLogger>();

    public ReconfigurableLoggerProvider() {
        this(LoggerProvider.noop());
    }

    public ReconfigurableLoggerProvider(LoggerProvider delegate) {
        this.delegate = delegate;
    }

    public LoggerBuilder loggerBuilder(String instrumentationScopeName) {
        this.lock.readLock().lock();
        try {
            ReconfigurableLoggerBuilder reconfigurableLoggerBuilder = new ReconfigurableLoggerBuilder(this.delegate.loggerBuilder(instrumentationScopeName), instrumentationScopeName, this.lock);
            return reconfigurableLoggerBuilder;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Logger get(String instrumentationScopeName) {
        this.lock.readLock().lock();
        try {
            InstrumentationScope instrumentationScope = new InstrumentationScope(instrumentationScopeName);
            Logger logger = (Logger)this.loggers.computeIfAbsent(instrumentationScope, scope -> new ReconfigurableExtendedLogger(this.delegate.get(instrumentationScopeName), this.lock));
            return logger;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void setDelegate(LoggerProvider delegate) {
        this.lock.writeLock().lock();
        try {
            this.delegate = delegate;
            this.loggers.forEach((instrumentationScope, reconfigurableTracer) -> {
                LoggerBuilder loggerBuilder = delegate.loggerBuilder(instrumentationScope.instrumentationScopeName);
                Optional.ofNullable(instrumentationScope.instrumentationScopeVersion).ifPresent(arg_0 -> ((LoggerBuilder)loggerBuilder).setInstrumentationVersion(arg_0));
                Optional.ofNullable(instrumentationScope.schemaUrl).ifPresent(arg_0 -> ((LoggerBuilder)loggerBuilder).setSchemaUrl(arg_0));
                reconfigurableTracer.setDelegate(loggerBuilder.build());
            });
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @VisibleForTesting
    protected class ReconfigurableLoggerBuilder
    implements LoggerBuilder {
        final LoggerBuilder delegate;
        final String instrumentationScopeName;
        String schemaUrl;
        String instrumentationScopeVersion;
        final ReadWriteLock lock;

        public ReconfigurableLoggerBuilder(LoggerBuilder delegate, String instrumentationScopeName, ReadWriteLock lock) {
            this.delegate = Objects.requireNonNull(delegate);
            this.instrumentationScopeName = Objects.requireNonNull(instrumentationScopeName);
            this.lock = lock;
        }

        public LoggerBuilder setSchemaUrl(String schemaUrl) {
            this.schemaUrl = schemaUrl;
            this.delegate.setSchemaUrl(schemaUrl);
            return this;
        }

        public LoggerBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
            this.instrumentationScopeVersion = instrumentationScopeVersion;
            this.delegate.setInstrumentationVersion(instrumentationScopeVersion);
            return this;
        }

        public Logger build() {
            InstrumentationScope instrumentationScope = new InstrumentationScope(this.instrumentationScopeName, this.schemaUrl, this.instrumentationScopeVersion);
            return (Logger)ReconfigurableLoggerProvider.this.loggers.computeIfAbsent(instrumentationScope, scope -> new ReconfigurableExtendedLogger(this.delegate.build(), this.lock));
        }
    }

    @VisibleForTesting
    protected static class ReconfigurableExtendedLogger
    implements ExtendedLogger {
        ReadWriteLock lock;
        ExtendedLogger delegate;

        public ReconfigurableExtendedLogger(Logger delegate, ReadWriteLock lock) {
            this.delegate = ReconfigurableExtendedLogger.requiresExtendedLogger(delegate);
            this.lock = lock;
        }

        public ExtendedLogRecordBuilder logRecordBuilder() {
            this.lock.readLock().lock();
            try {
                ExtendedLogRecordBuilder extendedLogRecordBuilder = this.delegate.logRecordBuilder();
                return extendedLogRecordBuilder;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        public void setDelegate(Logger delegate) {
            this.lock.writeLock().lock();
            try {
                this.delegate = ReconfigurableExtendedLogger.requiresExtendedLogger(delegate);
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        public boolean isEnabled() {
            this.lock.readLock().lock();
            try {
                boolean bl = this.delegate.isEnabled();
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        private static ExtendedLogger requiresExtendedLogger(Logger logger) {
            if (!(logger instanceof ExtendedLogger)) {
                boolean incubatorAvailable = false;
                try {
                    Class.forName("io.opentelemetry.api.incubator.logs.ExtendedDefaultLoggerProvider");
                    incubatorAvailable = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                throw new IllegalStateException("Delegate '" + String.valueOf(logger) + "' must be an instance of Extended. API incubator module is not on the classpath: " + incubatorAvailable);
            }
            return (ExtendedLogger)logger;
        }
    }
}

