package io.jenkins.plugins.opentelemetry.api.logs;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.logs.Severity;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.logs.data.Body;
import io.opentelemetry.sdk.resources.Resource;
import javax.annotation.Nullable;
import javax.annotation.processing.Generated;

/**
 * <p>
 * This class is auto generated by AutoValue and is not meant to be edited by hand.
 * </p>
 * <p>
 * It has been manually recopied because Jenkins has some specific requirements for the
 * `maven-compiler-plugin` configuration so we don't wnt to override its config to hook
 * the `com.google.auto.value:auto-value` annotation processor hat wouyld cause the
 * `META-INF/annotations/hudson.Extension` and the
 * `META-INF/services/annotations/hudson.init.Initializer` files to no longer be generated.
 * </p>
 */
@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_TestLogRecordData extends TestLogRecordData {

    private final Resource resource;

    private final InstrumentationScopeInfo instrumentationScopeInfo;

    private final long timestampEpochNanos;

    private final long observedTimestampEpochNanos;

    private final SpanContext spanContext;

    private final Severity severity;

    @Nullable
    private final String severityText;

    private final Body body;

    private final Attributes attributes;

    private final int totalAttributeCount;

    private AutoValue_TestLogRecordData(
            Resource resource,
            InstrumentationScopeInfo instrumentationScopeInfo,
            long timestampEpochNanos,
            long observedTimestampEpochNanos,
            SpanContext spanContext,
            Severity severity,
            @Nullable String severityText,
            Body body,
            Attributes attributes,
            int totalAttributeCount) {
        this.resource = resource;
        this.instrumentationScopeInfo = instrumentationScopeInfo;
        this.timestampEpochNanos = timestampEpochNanos;
        this.observedTimestampEpochNanos = observedTimestampEpochNanos;
        this.spanContext = spanContext;
        this.severity = severity;
        this.severityText = severityText;
        this.body = body;
        this.attributes = attributes;
        this.totalAttributeCount = totalAttributeCount;
    }

    @Override
    public Resource getResource() {
        return resource;
    }

    @Override
    public InstrumentationScopeInfo getInstrumentationScopeInfo() {
        return instrumentationScopeInfo;
    }

    @Override
    public long getTimestampEpochNanos() {
        return timestampEpochNanos;
    }

    @Override
    public long getObservedTimestampEpochNanos() {
        return observedTimestampEpochNanos;
    }

    @Override
    public SpanContext getSpanContext() {
        return spanContext;
    }

    @Override
    public Severity getSeverity() {
        return severity;
    }

    @Nullable
    @Override
    public String getSeverityText() {
        return severityText;
    }

    @Override
    public Body getBody() {
        return body;
    }

    @Override
    public Attributes getAttributes() {
        return attributes;
    }

    @Override
    public int getTotalAttributeCount() {
        return totalAttributeCount;
    }

    @Override
    public String toString() {
        return "TestLogRecordData{"
                + "resource=" + resource + ", "
                + "instrumentationScopeInfo=" + instrumentationScopeInfo + ", "
                + "timestampEpochNanos=" + timestampEpochNanos + ", "
                + "observedTimestampEpochNanos=" + observedTimestampEpochNanos + ", "
                + "spanContext=" + spanContext + ", "
                + "severity=" + severity + ", "
                + "severityText=" + severityText + ", "
                + "body=" + body + ", "
                + "attributes=" + attributes + ", "
                + "totalAttributeCount=" + totalAttributeCount
                + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TestLogRecordData) {
            TestLogRecordData that = (TestLogRecordData) o;
            return this.resource.equals(that.getResource())
                    && this.instrumentationScopeInfo.equals(that.getInstrumentationScopeInfo())
                    && this.timestampEpochNanos == that.getTimestampEpochNanos()
                    && this.observedTimestampEpochNanos == that.getObservedTimestampEpochNanos()
                    && this.spanContext.equals(that.getSpanContext())
                    && this.severity.equals(that.getSeverity())
                    && (this.severityText == null
                            ? that.getSeverityText() == null
                            : this.severityText.equals(that.getSeverityText()))
                    && this.body.equals(that.getBody())
                    && this.attributes.equals(that.getAttributes())
                    && this.totalAttributeCount == that.getTotalAttributeCount();
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= resource.hashCode();
        h$ *= 1000003;
        h$ ^= instrumentationScopeInfo.hashCode();
        h$ *= 1000003;
        h$ ^= (int) ((timestampEpochNanos >>> 32) ^ timestampEpochNanos);
        h$ *= 1000003;
        h$ ^= (int) ((observedTimestampEpochNanos >>> 32) ^ observedTimestampEpochNanos);
        h$ *= 1000003;
        h$ ^= spanContext.hashCode();
        h$ *= 1000003;
        h$ ^= severity.hashCode();
        h$ *= 1000003;
        h$ ^= (severityText == null) ? 0 : severityText.hashCode();
        h$ *= 1000003;
        h$ ^= body.hashCode();
        h$ *= 1000003;
        h$ ^= attributes.hashCode();
        h$ *= 1000003;
        h$ ^= totalAttributeCount;
        return h$;
    }

    static final class Builder extends TestLogRecordData.Builder {
        private Resource resource;
        private InstrumentationScopeInfo instrumentationScopeInfo;
        private long timestampEpochNanos;
        private long observedTimestampEpochNanos;
        private SpanContext spanContext;
        private Severity severity;
        private String severityText;
        private Body body;
        private Attributes attributes;
        private int totalAttributeCount;
        private byte set$0;

        Builder() {}

        @Override
        public TestLogRecordData.Builder setResource(Resource resource) {
            if (resource == null) {
                throw new NullPointerException("Null resource");
            }
            this.resource = resource;
            return this;
        }

        @Override
        public TestLogRecordData.Builder setInstrumentationScopeInfo(
                InstrumentationScopeInfo instrumentationScopeInfo) {
            if (instrumentationScopeInfo == null) {
                throw new NullPointerException("Null instrumentationScopeInfo");
            }
            this.instrumentationScopeInfo = instrumentationScopeInfo;
            return this;
        }

        @Override
        TestLogRecordData.Builder setTimestampEpochNanos(long timestampEpochNanos) {
            this.timestampEpochNanos = timestampEpochNanos;
            set$0 |= (byte) 1;
            return this;
        }

        @Override
        TestLogRecordData.Builder setObservedTimestampEpochNanos(long observedTimestampEpochNanos) {
            this.observedTimestampEpochNanos = observedTimestampEpochNanos;
            set$0 |= (byte) 2;
            return this;
        }

        @Override
        public TestLogRecordData.Builder setSpanContext(SpanContext spanContext) {
            if (spanContext == null) {
                throw new NullPointerException("Null spanContext");
            }
            this.spanContext = spanContext;
            return this;
        }

        @Override
        public TestLogRecordData.Builder setSeverity(Severity severity) {
            if (severity == null) {
                throw new NullPointerException("Null severity");
            }
            this.severity = severity;
            return this;
        }

        @Override
        public TestLogRecordData.Builder setSeverityText(String severityText) {
            this.severityText = severityText;
            return this;
        }

        @Override
        TestLogRecordData.Builder setBody(Body body) {
            if (body == null) {
                throw new NullPointerException("Null body");
            }
            this.body = body;
            return this;
        }

        @Override
        public TestLogRecordData.Builder setAttributes(Attributes attributes) {
            if (attributes == null) {
                throw new NullPointerException("Null attributes");
            }
            this.attributes = attributes;
            return this;
        }

        @Override
        public TestLogRecordData.Builder setTotalAttributeCount(int totalAttributeCount) {
            this.totalAttributeCount = totalAttributeCount;
            set$0 |= (byte) 4;
            return this;
        }

        @Override
        TestLogRecordData autoBuild() {
            if (set$0 != 7
                    || this.resource == null
                    || this.instrumentationScopeInfo == null
                    || this.spanContext == null
                    || this.severity == null
                    || this.body == null
                    || this.attributes == null) {
                StringBuilder missing = new StringBuilder();
                if (this.resource == null) {
                    missing.append(" resource");
                }
                if (this.instrumentationScopeInfo == null) {
                    missing.append(" instrumentationScopeInfo");
                }
                if ((set$0 & 1) == 0) {
                    missing.append(" timestampEpochNanos");
                }
                if ((set$0 & 2) == 0) {
                    missing.append(" observedTimestampEpochNanos");
                }
                if (this.spanContext == null) {
                    missing.append(" spanContext");
                }
                if (this.severity == null) {
                    missing.append(" severity");
                }
                if (this.body == null) {
                    missing.append(" body");
                }
                if (this.attributes == null) {
                    missing.append(" attributes");
                }
                if ((set$0 & 4) == 0) {
                    missing.append(" totalAttributeCount");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_TestLogRecordData(
                    this.resource,
                    this.instrumentationScopeInfo,
                    this.timestampEpochNanos,
                    this.observedTimestampEpochNanos,
                    this.spanContext,
                    this.severity,
                    this.severityText,
                    this.body,
                    this.attributes,
                    this.totalAttributeCount);
        }
    }
}
