/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.openmfa.service;

import hudson.model.User;
import hudson.security.HudsonPrivateSecurityRealm;
import hudson.security.SecurityRealm;
import io.jenkins.plugins.openmfa.MFAUserProperty;
import io.jenkins.plugins.openmfa.base.Service;
import io.jenkins.plugins.openmfa.service.model.UserInfo;
import io.jenkins.plugins.openmfa.util.JenkinsUtil;
import io.jenkins.plugins.openmfa.util.TOTPUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Optional;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.security.LastGrantedAuthoritiesProperty;
import lombok.Generated;

@Service
public class UserService {
    @Generated
    private static final Logger log = Logger.getLogger(UserService.class.getName());

    public Collection<UserInfo> getAllUsersWithMFAStatus() {
        return this.getUsers().stream().filter(u -> !"SYSTEM".equals(u.getId())).map(this::getUserMFAInfo).toList();
    }

    public long getEnabledMFACount() {
        return this.getUsers().stream().filter(this::isMFAEnabled).count();
    }

    public long getTotalUserCount() {
        return this.getUsers().size();
    }

    public UserInfo getUserMFAInfo(User user) {
        return new UserInfo(user.getId(), user.getFullName(), TOTPUtil.isMFAEnabled(user));
    }

    public boolean isMFAEnabled(User user) {
        return TOTPUtil.isMFAEnabled(user);
    }

    public void resetMFA(User user) throws IOException {
        JenkinsUtil.checkAdminPermission();
        MFAUserProperty property = MFAUserProperty.forUser(user);
        if (property != null) {
            property.setSecret(null);
            user.save();
            log.info(String.format("MFA reset for user: %s by admin", user.getId()));
        }
    }

    private Collection<User> getUsers() {
        SecurityRealm realm;
        Optional<Jenkins> jenkins = JenkinsUtil.getJenkins();
        if (jenkins.isPresent() && (realm = jenkins.get().getSecurityRealm()) instanceof HudsonPrivateSecurityRealm) {
            return ((HudsonPrivateSecurityRealm)realm).getAllUsers();
        }
        return User.getAll().stream().filter(u -> u.getProperty(LastGrantedAuthoritiesProperty.class) != null).toList();
    }
}

