/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.openmfa;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import lombok.Generated;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
public class MFAGlobalConfiguration
extends GlobalConfiguration {
    private String issuer = "Jenkins";
    private boolean requireMFA = false;

    @NonNull
    public static MFAGlobalConfiguration get() {
        return (MFAGlobalConfiguration)((Object)ExtensionList.lookupSingleton(MFAGlobalConfiguration.class));
    }

    public MFAGlobalConfiguration() {
        this.load();
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    @NonNull
    public GlobalConfigurationCategory getCategory() {
        return GlobalConfigurationCategory.get(GlobalConfigurationCategory.Security.class);
    }

    public String getDefaultIssuer() {
        return "Jenkins";
    }

    @NonNull
    public String getDisplayName() {
        return "OpenMFA";
    }

    @DataBoundSetter
    public void setIssuer(String issuer) {
        this.issuer = issuer != null && !issuer.trim().isEmpty() ? issuer.trim() : "Jenkins";
    }

    @DataBoundSetter
    public void setRequireMFA(boolean requireMFA) {
        this.requireMFA = requireMFA;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public boolean isRequireMFA() {
        return this.requireMFA;
    }
}

